<?php
function terbilang($n)
{
    if ($n < 0)
    {
        return 'minus ' . terbilang(-$n);
    }
    else if ($n < 10)
    {
        switch ($n)
        {
            case 0:return 'zero';
            case 1:return 'one';
            case 2:return 'two';
            case 3:return 'three';
            case 4:return 'four';
            case 5:return 'five';
            case 6:return 'six';
            case 7:return 'seven';
            case 8:return 'eight';
            case 9:return 'nine';
        }
    }
    else if ($n < 100)
    {
        $kepala = floor($n / 10);
        $sisa   = $n % 10;
        if ($kepala == 1)
        {
            if ($sisa == 0)
            {
                return 'ten';
            }
            else if ($sisa == 1)
            {
                return 'eleven';
            }
            else if ($sisa == 2)
            {
                return 'twelve';
            }
            else if ($sisa == 3)
            {
                return 'thirteen';
            }
            else if ($sisa == 5)
            {
                return 'fifteen';
            }
            else if ($sisa == 8)
            {
                return 'eighteen';
            }
            else
            {
                return terbilang($sisa) . 'teen';
            }

        }
        else if ($kepala == 2)
        {
            $hasil = 'twenty';
        }
        else if ($kepala == 3)
        {
            $hasil = 'thirty';
        }
        else if ($kepala == 5)
        {
            $hasil = 'fifty';
        }
        else if ($kepala == 8)
        {
            $hasil = 'eighty';
        }
        else
        {
            $hasil = terbilang($kepala) . 'ty';
        }

    }
    else if ($n < 1000)
    {
        $kepala = floor($n / 100);
        $sisa   = $n % 100;
        $hasil  = terbilang($kepala) . ' hundred';
    }
    else if ($n < 1000000)
    {
        $kepala = floor($n / 1000);
        $sisa   = $n % 1000;
        $hasil  = terbilang($kepala) . ' thousand';
    }
    else if ($n < 1000000000)
    {
        $kepala = floor($n / 1000000);
        $sisa   = $n % 1000000;
        $hasil  = terbilang($kepala) . ' million';
    }
    else
    {
        return false;
    }

    if ($sisa > 0)
    {
        $hasil .= ' ' . terbilang($sisa);
    }

    return $hasil;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Print PO Payment</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Jquery Core Js -->    
    <script src="<?php echo base_url('asset/plugins/jquery/jquery.min.js'); ?>"></script>
	<!-- Bootstrap Core Css -->
	<link href="<?php echo base_url('asset/plugins/bootstrap/css/bootstrap.css'); ?>" rel="stylesheet">
	<!-- jquery UI JS -->
	<script type="text/javascript" src="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>
	<!-- Bootstrap Core Js -->
	<script src="<?php echo base_url('asset/plugins/bootstrap/js/bootstrap.js'); ?>"></script>
	<style type="text/css"> 

		body {
		  background: rgb(204,204,204); 
		}
/* 
		@page{ 
		    size: 21cm 16cm;
		    display: block; 
		    margin-bottom: 0.5cm;
		} */
		@media print {
		  body, page {
		    margin: 0 auto;
		    box-shadow: 0;
		  }
		}
		.srstyle-pjstitle{
			font-size: 30px;
		}
		.srstyle-pjstitles{
			margin-left: 115px;
			font-size: 18px;
		}
		.srstyle-id{
			font-size: 18px;
		}
		p{
			margin: 0px;
		}
		.srtyle-tbdetailprint tr th{
			text-align: center;
			white-space: nowrap;
		}

		.srstyle-tacenter{
			text-align: center;
		}

		.srstyle-taright{
			text-align: right;
		}

		.srstyle-signature div{
			min-height:100px;
			border: 0.1px solid gray;
			margin: 0px !important;
		}
		.srstyle-signature,
		.srstyle-ketbayar,
		.srstyle-ketkirim,
		.srstyle-transwarning,
		.srstyle-terbilang
		{
			padding: 0px !important;
		}

		.srstyle-ketbayar div{
			min-height:100px;
			border: 0.1px solid gray;
			font-size: 18px;
		}

		.srstyle-ketkirim div{
			min-height:50px;
			border: 0.1px solid gray;
			font-size: 18px;
		}

		.srstyle-terbilang div{
			min-height:35px;
			border: 0.1px solid gray;
		}

		.srstyle-transwarning div{
			min-height:35px;
			border: 0.1px solid gray;
		}

		.srstyle-sotitle{
			font-size: 20px;
			background-color: gray;
			text-align: center;
			color: white;
		}

		.srstyle-headerleft,
		.srstyle-headerright{
			font-size: 16px;
		}
		<?php
			if($paper_size == 'a5'){
				$ps = '@page{' 
					    .'size: 21cm 16cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 

			if($paper_size == 'a4'){
				$ps = '@page{' 
					    .'size: 21cm 29.7cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 
		?>

	</style>
</head>
<body>
	<table class="table table-bordered">
		<thead>

		</thead>
		<tbody>
				<tr>
					<td>
						<p class="srstyle-pjstitle"><span><img class="logo-pjs" src="<?php echo base_url('asset/images/logo-pjs.png'); ?>" width="90" height="50"></span>&nbsp; &nbsp;PT PANCA JAYA SETIA</p>
						<p class="srstyle-pjstitles">AUTO SERVICE EQUIPMENT</p>
					</td>
					<td>
						<p class="srstyle-id">No: <?php echo $header ['pbpo_no']; ?></p>
						<p class="srstyle-id">Date: <?php echo date('Y-m-d'); ?></p>
						<p class="srstyle-sotitle"><b><i><u>PO Payment</u></i></b></p>
					</td>
				</tr>
				<tr>
					<td class="srstyle-headerleft">
						<p>Supplier: <?php echo $header ['mssp_nm']; ?></p>
						<p>Admin: <?php echo $header ['msus_nm']; ?></p>
					</td>
					<td class="srstyle-headerright">
						<p>PT. PANCA JAYA SETIA</p>
						<p>Jl. Jelambar Barat III No. 12</p>
						<p>Jakarta Barat 11460</p>
						<p>Telp : (021) 5677081 (Hunting)</p>
						<p>Fax : (021) 5649089, 5696250</p>

					</td>
				</tr>

		</tbody>
	</table>

	<table class="table table-bordered srtyle-tbdetailprint">
    <thead>
      <tr>
        <th>Total (Rp)</th>
        <th>Terbayar (Rp)</th>
        <th>Remaining (Rp)</th>
        <th>Pay (Rp)</th>
      </tr>
    </thead>
    <tbody>

	    <?php
foreach ($detail as $key => $value)
{
			$sisa = $value['trpo_total'] - $value['trpo_terbayar'];
 			?>
		    <tr>
		        <td class="srstyle-taright"><?php echo number_format($value['trpo_total'], 2); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['trpo_terbayar'], 2); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($sisa, 2); ?></td>
		        <td class="srstyle-taright"><?php echo number_format($value['pbpo_jlhbayar'], 2); ?></td>
		    </tr><?php
}?>
<!-- 
		<tr>
			<td colspan="9" style="text-align:right;"><b>Sub Total: </b></td>
			<td class="srstyle-taright"><b><?php //echo number_format($subtotal, 2); ?></b></td>
		</tr>
		<tr>
			<td colspan="9" style="text-align:right;"><b>PPN (10%): </b></td>
			<td class="srstyle-taright"><b><?php //echo number_format((10 / 100) * $subtotal, 2); ?></b></td>
		</tr> -->

    </tbody>
	</table>

    <div class="col-md-12 srstyle-terbilang">
	   <div class="col-md-12"><b>Terbilang: <?php echo ucwords(terbilang($value['pbpo_jlhbayar'])); ?> </b></div>
    </div>

    <div class="col-md-12 srstyle-ketkirim">
	   <div class="col-md-12">KET TGL BAYAR: <?php echo $header['pbpo_tgl']; ?> </div>
    </div>

	<div class="col-md-12 srstyle-signature">
	    <div class="col-md-4 col-sm-4 col-xs-4 srstyle-tacenter">Salesman</div>
	    <div class="col-md-4 col-sm-4 col-xs-4 srstyle-tacenter">Customer</div>
	    <div class="col-md-4 col-sm-4 col-xs-4 srstyle-tacenter">Hormat Kami,</div>
	</div>

	<script type="text/javascript">
    	window.print();
    </script>


</page>
</body>

</html>