<?php
function terbilang($n)
{
    if ($n < 0)
    {
        return 'minus ' . terbilang(-$n);
    }
    else if ($n < 10)
    {
        switch ($n)
        {
            case 0:return 'zero';
            case 1:return 'one';
            case 2:return 'two';
            case 3:return 'three';
            case 4:return 'four';
            case 5:return 'five';
            case 6:return 'six';
            case 7:return 'seven';
            case 8:return 'eight';
            case 9:return 'nine';
        }
    }
    else if ($n < 100)
    {
        $kepala = floor($n / 10);
        $sisa   = $n % 10;
        if ($kepala == 1)
        {
            if ($sisa == 0)
            {
                return 'ten';
            }
            else if ($sisa == 1)
            {
                return 'eleven';
            }
            else if ($sisa == 2)
            {
                return 'twelve';
            }
            else if ($sisa == 3)
            {
                return 'thirteen';
            }
            else if ($sisa == 5)
            {
                return 'fifteen';
            }
            else if ($sisa == 8)
            {
                return 'eighteen';
            }
            else
            {
                return terbilang($sisa) . 'teen';
            }

        }
        else if ($kepala == 2)
        {
            $hasil = 'twenty';
        }
        else if ($kepala == 3)
        {
            $hasil = 'thirty';
        }
        else if ($kepala == 5)
        {
            $hasil = 'fifty';
        }
        else if ($kepala == 8)
        {
            $hasil = 'eighty';
        }
        else
        {
            $hasil = terbilang($kepala) . 'ty';
        }

    }
    else if ($n < 1000)
    {
        $kepala = floor($n / 100);
        $sisa   = $n % 100;
        $hasil  = terbilang($kepala) . ' hundred';
    }
    else if ($n < 1000000)
    {
        $kepala = floor($n / 1000);
        $sisa   = $n % 1000;
        $hasil  = terbilang($kepala) . ' thousand';
    }
    else if ($n < 1000000000)
    {
        $kepala = floor($n / 1000000);
        $sisa   = $n % 1000000;
        $hasil  = terbilang($kepala) . ' million';
    }
    else
    {
        return false;
    }

    if ($sisa > 0)
    {
        $hasil .= ' ' . terbilang($sisa);
    }

    return $hasil;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Print Purchase Return</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Bootstrap Core Css -->
	<link href="<?php echo base_url('asset/plugins/bootstrap/css/bootstrap.css'); ?>" rel="stylesheet">
	<!-- jquery UI JS -->
	<script type="text/javascript" src="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>
	<!-- Bootstrap Core Js -->
	<script src="<?php echo base_url('asset/plugins/bootstrap/js/bootstrap.js'); ?>"></script>
	<style type="text/css">
		body {
		  background: rgb(204,204,204); 
		    font-size: 10px;
		}
/* 
		@page{ 
		    size: 21cm 16cm;
		    display: block; 
		    margin-bottom: 0.5cm;
		} */
		@media print {
		  body, page {
		    /* margin: 0 auto; */
		    box-shadow: 0;
		    font-size: 10px;
		  }
		}
	    .headerdocnames{
	    	text-align: center;
	    	width : 10cm;
	    }
		.srstyle-pjstitle{
			margin-top: -4.9px;
            text-align: right;
            margin-right: 11px;
		}
		.srstyle-pjstitles{
			margin-left: 115px;
			margin-top: 1cm;
			font-size: 10px;

		}
		.srstyle-id{
			font-size: 10px;
		}
		p{
			margin: 0px;
			font-size: 10px;
		}
		.srtyle-tbdetailprint tr th{
			text-align: center;
			white-space: nowrap;
		}

		.srstyle-tacenter{
			text-align: center;
			margin-bottom: -0.2cm;
		}

		.srstyle-taright{
			text-align: right;
			margin-bottom: -0.2cm;
		}

		.srstyle-signature div{
		    text-align: center;
		    min-height: 60px;
		    border: 0.1px solid gray;
		    /* margin: 0.5cm !important; */
		    margin-top: 16px;
		    margin-left: 35px;
		}
		.srstyle-signature2 div{
		    text-align: center;
		    min-height: 60px;
		    border: 0.1px solid gray;
		    /* margin: 0.5cm !important; */
		    margin-top: 16px;
		    margin-left: 22px;
		}
		.srstyle-notes div{
		    text-align: center;
		    min-height: 50px;
		    border: 0.1px solid #050000;
		    /* margin: 0.5cm !important; */
		    margin-left: 2cm;

		}
		.borderno{
			border: 0.1px solid rgb(221, 221, 221);
            text-align: left;
            margin-top: 1px;
            margin-bottom: 7px;
            max-width: 300px;
            min-height: 21px;
		}
		.borderreason{
			border: 0.1px solid rgb(221, 221, 221);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
            min-height: 21px;
		}
		.boorderbold{
			border: 0.1px solid rgba(17, 14, 14, 0.81);
            text-align: center;
            margin-top: -14px;
            margin-bottom: 7px;
		    min-height: 70px;
		}
		.srstyle-signature,
		.srstyle-ketbayar,
		.srstyle-ketkirim,
		.srstyle-transwarning,
		.srstyle-terbilang
		{
			padding: 0px !important;
			margin-bottom: -0.2cm;
		}

		.srstyle-ketbayar div{
			min-height:100px;
			border: 0.1px solid gray;
			font-size: 10px;
		}

		.srstyle-ketkirim div{
			min-height:50px;
			border: 0.1px solid gray;
			font-size: 10px;
			margin-bottom: -0.2cm;
		}

		.srstyle-terbilang div{
			min-height:35px;
			border: 0.1px solid gray;
		}

		.srstyle-transwarning div{
			min-height:35px;
			border: 0.1px solid gray;
			margin-bottom: -0.2cm;
		}

		.srstyle-sotitle{
			font-size: 10px;
			background-color: gray;
			text-align: center;
			color: white;
			margin-bottom: -0.2cm;
		}

		.srstyle-headerleft,
		.srstyle-headerright{
			font-size: 10px;
			margin-bottom: -0.2cm;
		}
		.addrespjs{
           margin-top: -47px;
           margin-bottom: -1px;

		}
		.marginheader{
			margin-bottom: -0.2cm;
			margin-top: -0.1cm;
		}
		td{
			margin-bottom: -0.2cm;
		}
		table{
			margin-bottom: -22px;
		}
		<?php
			if($paper_size == 'a5'){
				$ps = '@page{' 
					    .'size: 21cm 14.8cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 

			if($paper_size == 'a4'){
				$ps = '@page{' 
					    .'size: 21cm 29.7cm;'
					    .'display: block;' 
					    .'margin-bottom: 0.5cm;'
						.'}';
				echo $ps;
			} 
		?>
	</style>
</head>
<body>

	<table class="table table-bordered" >
		<thead>

		</thead>
		<tbody>
				<p class="srstyle-pjstitle"><span><img class="logo-pjs" src="<?php echo base_url('asset/images/logo-pjs.png'); ?>" width="110px;" height="50px;" style="    margin-top: 0.2cm; text-align: right; margin-right: -2px;">
                        <div class="addrespjs">
                        <p><strong>PT. PANCA JAYA SETIA</strong></p>
                        <p>Jl. Jelambar Barat III No. 12 Jakarta Barat 11460</p>
                        <p>Telp : (021) 5677081 (Hunting) Fax : (021) 5649089, 5696250</p>
                        </div>

                        <h5 style="text-align: center; margin-top: 0.8cm;"><b>Purchase Return</b></h5>
                        
				<div class="col-md-12">
					<tr>
					<td colspan="4" style="text-align:left;" class="srstyle-headerleft">
						<p><b>Purchase Return</b></p>
						<p class="srstyle-id">Date: <?php echo date('d-m-Y'); ?></p>
						<p class="srstyle-id">No: <?php echo $header['trpt_no']; ?></p>
					</td>
					<td colspan="4" style="text-align:left;">
						<p>Name : <?php echo $header['mssp_nm']; ?></p>
						<p>CP : <?php echo $header['mssp_cp']; ?></p>
						<p>Address : <?php echo $header['mssp_almt_jln']; ?></p>
					</td>
					</tr>
				</div>

		</tbody>
	</table>

</body>

		<div class="borderreason"><p style="margin-top: 3px; margin-left: 3px;">Reason For Return <?php echo $header['mscb_nm']; ?></p></div>
		<div class="borderno"><p style="margin-top: 3px; margin-left: 3px;">PO Transaction No: <?php echo $header['trpt_no']; ?></p></div>
		<div class="borderno" style="margin-left: 13cm; margin-top: -29px;"><p style="margin-top: 3px; margin-left: 3px;">PO Transaction Date: <?php echo $header['trpt_tgl']; ?></p></div>

	<table class="table table-bordered srtyle-tbdetailprint margindetail">
    <thead>
      <tr>
        <th style="width:400px;"><p style="margin-top: -4px; padding-top: -2px;">Product Name</p></th>
        <th><p style="margin-top: -4px;">Buy QTY</p></th>
        <th><p style="margin-top: -4px;">Buy Price</p></th>
        <th><p style="margin-top: -4px;">Rtrn Qty</p></th>
        <th><p style="margin-top: -4px;">Rtrn Price</p></th>
      </tr>
    </thead>
    <tbody>

	    <?php
$subtotal = 0;
foreach ($detail as $key => $value)
{
    $total = $value['dtpo_qtyterima'] * $value['dtpo_nett'];
    $totalretur = $value['dtso_qtyretur'] * $value['dtpo_nett'];
    $subtotal += $total;?>
		    <tr>
		        <td><p style="margin-top: -4px;"><?php echo $value['mspd_nm']; ?></p></td>
		        <td class="srstyle-taright"><p style="margin-top: -4px;"><?php echo number_format($value['dtpo_qtyterima']); ?></p></td>
		        <td class="srstyle-taright"><p style="margin-top: -4px;"><?php echo number_format($total,2); ?></p></td>
		        <td class="srstyle-taright"><p style="margin-top: -4px;"><?php echo number_format($value['dtpo_qtyretur']); ?></p></td>
		        <td class="srstyle-taright"><p style="margin-top: -4px;"><?php echo number_format($totalreturl,2); ?></p></td>
		    </tr><?php
}?>

    </tbody>
	</table>

	<div class="borderreason"><p style="margin-top: 3px; margin-left: 3px;">Return (Pick-Up by PJS / Sent by Customer); Condition (??%); Price Estimation (Rp???); Type of Return (Cashback / Voucher)<?php echo $header['mscb_nm']; ?></p></div>

	<div class="boorderbold" style="max-width: 440px; margin-top: 20px; margin-bottom: 7px;"><p style="margin-top: 3px; margin-left: 3px;">Working Order Terms and Conditions</p></div>

    <div class="boorderbold" style="margin-left: 439px; margin-top: -77px;"><p style="margin-top: 3px; margin-left: 3px;">Purchase Return Notes </br></br> <?php echo $header['trpt_catatan'];?></p></div>
    <table class="table table-bordered" >
        <thead>

        </thead>
        <tbody>

            <div class="col-md-12">
                <tr>
                    <td colspan="3" style="text-align:center; height: 50px;" class="srstyle-headerleft">
                        <p class="srstyle-id">Purchasing Admin Sign</p>
                    </td>
                    <td colspan="3" style="text-align:center;" class="srstyle-headerleft">
                        <p class="srstyle-id">Head Purchasing (or) Purchasing Deputy Sign</p>
                    </td>
                     <td colspan="3" style="text-align:center;" class="srstyle-headerleft">
                        <p class="srstyle-id">Head Warehouse (or) Stock Control Manager Sign</p>
                    </td>
                     <td colspan="3" style="text-align:center;" class="srstyle-headerleft">
                        <p class="srstyle-id">Warehouse Sign</p>
                    </td>
                </tr>
            </div>
        </tbody>
    </table>

    <script type="text/javascript">
    	window.print();
    </script>

</body>

</html>