<?php 

  function set_estdate(){
    $datetime = new DateTime(date('Y-m-d'));
    $datetime->modify('+2 day');
    return $datetime->format('Y-m-d');
  }

  function fset_input_value($action, $header, $trso, $trsi, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header[$trsi];
      }else{
        return $header[$trso];
      }
  }

  function fset_input_dlvyadd($action, $header, $trso, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header['mscs_almt_jln']. '  '. $header['mscs_almt_kota']. '  '. $header['mscs_almt_provinsi'];
      }else{
        return $header[$trso];
      }
  }

  function fset_input_npwpadd($action, $header, $trso, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header['mscs_almt_jln']. '  '. $header['mscs_almt_kota']. '  '. $header['mscs_almt_provinsi'];
      }else{
        return $header[$trso];
      }
  }

  function fset_input_customer($action, $header, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header['trsi_mscs_no']. ' - '. $header['mscs_nm'];
      }else{
        return $header['trso_mscs_no']. ' - '. $header['mscs_nm'];
      }
  }

  function fset_input_notes($action, $header, $trso, $trsi, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        $notes = "Reference from Sales Inquery: ". $header['trsi_no'];
        if($header['trsi_top'] != ''){
            $notes .= '&#10 TOP: '. $header['trsi_top'];
        }
        if($header['trsi_catatan'] != ''){
          $notes .= '&#10 Notes: '. $header['trsi_catatan'];
        } 
        return $notes;
      }else{
        return $header['trso_catatan'];
      }
  }  

?>

<nav class="navbar">
    <div class="container-fluid">
        <div class="pull-right navbar-right">
            
            <?php 
            if(fcek_hak_akses('.CB0.')) { ?>
                <a class="btn-view-list" id="btn-view-list" href="<?php echo base_url('sales_order/index'). '/'. $tipe_trans; ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="View List">view_list</i>
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.CB1.')) { ?>
                <a class="btn-new" id="btn-new" kode-akses=".CA1." href="<?php echo base_url('sales_order/sales_order_new'). '/default/'. $tipe_trans; ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="New">insert_drive_file</i>
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.CB2.')) {
                if($header['is_spcreated'] == 0 && $header['trso_lock'] == 'N' && $header['is_sdcreated'] == 0) { ?>
                    <a class="btn-edit" id="btn-edit" kode-akses=".CA2." href="javascript:void(0);">
                        <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Edit">create</i>
                    </a><?php
                }
            } ?>            

            <?php 
            if(fcek_hak_akses('.CB6.')) { ?>
                <a class="btn-print" id="btn-print" href="javascript:void(0);">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Print">print</i>
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.CB5.')) { 
                if($header['is_spcreated'] == 0 && $header['trso_lock'] == 'N' && $header['is_sdcreated'] == 0) { ?>
                    <a class="btn-void" id="btn-void" href="javascript:void(0);">
                        <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Void">delete_forever</i>                    
                    </a><?php
                }
            } ?>

            <?php 
            if(fcek_hak_akses('.CB1.')) { ?>
                <a class="btn-import-si srstyle-btnnavbar" id="btn-import-si" href="javascript:void(0);">
                    <button type="button" class="btn">Import SI</button>      
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.EC1.')) { 
              if($header['trso_terbayar'] < $header['trso_total']) { ?>
                <a class="btn-input-payment srstyle-btnnavbar" id="btn-input-payment" href="javascript:void(0);">
                    <button type="button" class="btn">Input Payment</button>      
                </a><?php
              }
            } ?>

            <?php 
            if(fcek_hak_akses('.DB1.')) {
                if($header['trso_totalqtysd'] < $header['trso_totalqty'] && $header['trso_lock'] == 'N') { ?>
                    <a class="btn-create-sd srstyle-btnnavbar" id="btn-create-sd" href="javascript:void(0);">
                        <button type="button" class="btn">Create Sales Delivery</button>      
                    </a><?php
                }
            } ?>                      

            <?php 
            //if(fcek_hak_akses('.CC1.')) { ?> 
                <!-- <a class="btn-create-sr srstyle-btnnavbar" id="btn-create-sr" href="javascript:void(0);">
                    <button type="button" class="btn">Create Sales Return</button>      
                </a> -->
              <?php
            //} ?>

            <?php 
            if(fcek_hak_akses('.CB7.')) { 
                if($action == 'view' && $header['trso_lock'] == 'N' && $header['trso_void'] == 0) { ?>
                    <a class="btn-lockso srstyle-btnnavbar" id="btn-lockso" href="javascript:void(0);">
                        <button type="button" class="btn">Lock</button>
                    </a><?php
                }
            } ?>

            <?php 
            if(fcek_hak_akses('.CB8.')) { 
                if($action == 'view' && $header['trso_lock'] == 'Y' && $header['trso_void'] == 0) { ?>
                    <a class="btn-cancellockso srstyle-btnnavbar" id="btn-cancellockso" href="javascript:void(0);">
                        <button type="button" class="btn">Unlock</button>
                    </a><?php
                }
            } ?>

        </div>
        <?php $this->load->view('v_navbar_topleft') ?>  
    </div>
</nav>

<style type="text/css">
.produknamecol {
  min-width: 400px;
  padding-top: 0;
}
.fixedname {
     position:absolute;
     margin :  0px;
     left: 0%;
     padding-top: 0;
}
.fixed_table {
  min-width: 150px;
  
}
.display_id{
  display: none;
}
</style>

<div class="row clearfix">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">                      
        <div class="card srstyle-card">
            <div id="data-form-container">                

                <!-- ============================================ Sales Order Form ====================================== -->
                <div class="srstyle-title">
                  <span>Sales Order</span>                

                  <?php
                  if($action == 'view' && $header['trso_lock'] == 'Y'){ ?>
                      <b class="pull-right" style="margin-right:30px;">SO LOCKED</b><?php
                  } ?>
                  
                </div>
                        
                <form id="sales_order-form" autocomplete="off" method="POST" action="<?php echo base_url('sales_order/sales_order_new_simpan'); ?>">      
                    <input type="hidden" name="key" id="key" value="<?php echo $key ?>" >   
                    <input type="hidden" name="hash_key" id="hash_key" value="<?php echo $hash_key ?>" >                    
                    <input type="hidden" name="trso_cekint" id="trso_cekint" value="<?php echo ($action == 'view') ? $header['trso_cekint'] : ''; ?>" >
                    <input type="hidden" name="top_total" id="top_total" value="" >
                    <input type="hidden" name="top_persen_total" id="top_persen_total" value="" >
                    <input type="hidden" id="mscs_jenis" value="<?php echo ($action == 'view' || $action == 'new_import') ? $header['mscs_jenis'] : ''; ?>">
                    <input type="hidden" name="is_sdcreated" id="is_sdcreated" value="<?php echo ($action == 'view') ? $header['is_sdcreated'] : ''; ?>" >
                    <input type="hidden" name="is_spcreated" id="is_spcreated" value="<?php echo ($action == 'view') ? $header['is_spcreated'] : ''; ?>" >
                    <input type="hidden" name="trso_fin" id="trso_fin" value="<?php echo ($tipe_trans == 'F') ? 'F':'C'; ?>" >
                    <input type="hidden" name="trso_stcopy" id="trso_stcopy" value="<?php echo ($action == 'view') ? $header['trso_stcopy'] : ''; ?>" >                    
                    <input type="hidden" name="trso_sisadp" id="trso_sisadp" value="<?php echo ($action == 'view') ? $header['trso_sisadp'] : ''; ?>" >
                    
                    <?php 
                    if($action == 'view'){                     
                            if($header['trso_void'] == 1) {?>
                                <div class="alert-danger srstyle-boxvoid">
                                    <h2>VOID</h2>
                                </div>
                  <?php     }                       
                    } ?>                

                    <?php $trso_mscb_no = ($action == 'view') ? $header['trso_mscb_no'] : $this->session->userdata('user_aktif')['msus_mscb_no']; ?>      

                    <!-- SRS Toogle -->
                    <div class="col-ms-12 col-md-12 col-xs-12 SRSHeaderFormTop"> 

                        <!-- SRS Toogle -->
                        <div class="lokasi_cb_area SRSLokasiCbArea">
                              <label class="SRSToogleContainer">
                                  <input type="radio" name="trso_mscb_no" id="trso_mscb_no" value="<?php echo $trso_mscb_no; ?>" checked disabled>
                                  <div class="SRSToogleArea"> <?php echo $trso_mscb_no; ?> </div>
                              </label>
                        </div>

                        <div class="SRSBox">                            
                             <?php echo ($action == 'view') ? $header['trso_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - '. $this->session->userdata('user_aktif')['msus_nm']; ?>
                        </div>                         

                        <div class="SRSBox">
                          <input type="text" class="srstyle-date-trans" name="trso_tgl" id="trso_tgl" value="<?php echo (($action == 'view') ? $header['trso_tgl'] : date('Y-m-d H:i:s')); ?>" readonly>
                        </div>

                        <?php 
                        if($action == 'view'){ ?>                            
                            <div class="SRSBox">                            
                                 <span>Not yet SD: </span><?php echo ($header['trso_lock'] == 'N') ? $header['trso_totalqty'] - $header['trso_totalqtysd'] : 0; ?>
                            </div><?php
                        } ?>

                        <?php 
                        if($action == 'view'){ ?>
                            <div class="SRSBox">                            
                                 <span>Total Unpaid: Rp </span><span class="auto-numeric"><?php echo $header['trso_total'] - $header['trso_terbayar']; ?></span>
                            </div><?php
                        } ?>

                        <?php 
                      if($action == 'view'){                                                   
                          if($header['trso_terbayar'] >= $header['trso_total']){
                              $payment_status = 'SETTLED';
                              $payment_status_bg = '#20ff80';
                          }else{
                              $payment_status = 'UNSETTLED';
                              $payment_status_bg = '#FF6347';                                                            
                          } ?>

                          <div class="SRSBox" style="background-color:<?php echo $payment_status_bg; ?>"> 
                              <?php echo $payment_status; ?>
                          </div><?php
                      } ?>

                      <?php 
                      if($action == 'view'){                                                                             
                          if($header['trso_totalqtysd'] >= $header['trso_totalqty'] || $header['trso_lock'] == 'Y'){
                              $dlv_status = 'SD-COMPLETE';
                              $dlv_status_bg = '#20ff80';
                          }elseif($header['trso_totalqtysd'] < $header['trso_totalqty'] && $header['trso_lock'] == 'N'){
                              $dlv_status = 'SD-INCOMPLETE';
                              $dlv_status_bg = '#FF6347';                                                            
                          } ?>

                          <div class="SRSBox" style="background-color:<?php echo $dlv_status_bg; ?>"> 
                              <?php echo $dlv_status; ?>
                          </div><?php
                      } ?>  

                        <div class="SRSBox pull-right">
                             <span>Kurs: </span><span class="auto-numeric"><?php echo $kurs; ?></span>
                        </div>

                        <div class="SRSBox pull-right">
                           <?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>
                        </div>

                        <?php
                        if($action == 'view' && $this->session->userdata('svlogin') == 'C' && $tipe_trans == 'F'){ ?>
                          <div class="SRSBox pull-right srstyle-cursor" id="stcopy">
                               <?php echo $header['trso_stcopy']; ?>
                          </div>
                          <?php
                        } ?>

                    </div>          

                    <div class="clearfix"></div>
                            
                    <!-- container kolom -->
                    <div class="col-md-6 col-xs-12">      
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">  
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_no">SO #</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                <input type="text" name="trso_no" maxlength="12" onkeypress="return fis_alphanumericchar(event)" class="form-control" <?php if($this->session->userdata('svlogin') == 'C' || ($this->session->userdata('svlogin') == 'F' && $action == 'view')){ echo 'readonly'; } ?> id="trso_no" placeholder="Auto" value="<?php echo (($action == 'view') ? $header['trso_no'] : '' ); ?>">
                            </div>
                          </div>                         
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_msus_no">User:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_msus_no" class="form-control" readonly id="trso_msus_no" value="<?php //echo ($action == 'view') ? $header['trso_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - '. $this->session->userdata('user_aktif')['msus_nm']; ?>">    
                              </div>                            
                          </div> -->
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_nm">Area:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_mscb_no" class="form-control" readonly id="trso_mscb_no" value="<?php //echo (($action == 'view') ? $header['mscb_no']. ' - '. $header['mscb_nm'] : $this->session->userdata('user_aktif')['msus_mscb_no']. ' - '. $this->session->userdata('user_aktif')['mscb_nm'] ); ?>">
                              </div>                            
                          </div> -->
                         <!--  <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_tgl">Date:</label>                                                          
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding srstyle-boxinputicon" id="container-calendar">
                                <input type="text" name="trso_tgl" id="trso_tgl" class="form-control" readonly disabled value="<?php //echo (($action == 'view') ? $header['trso_tgl'] : date('Y-m-d') ); ?>">
                                <button type="button" class="srstyle-cursor srstyle-inputicon" id="btn-edit-tanggal"><i class="material-icons">today</i></button>
                              </div>                                                        
                          </div> -->
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_tglestkirim">Estimation Date:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding" id="container-calendar">
                                <input type="text" name="trso_tglestkirim" id="trso_tglestkirim" class="form-control datepicker" placeholder="Estimation Date" value="<?php echo (($action == 'view') ? $header['trso_tglestkirim'] : set_estdate()); ?>">
                              </div>                                                        
                          </div>                          
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_mssl_no">Sales:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-boxinputicon">            
                                <div class="srstyle-combobox">
                                  <div id="trso_mssl_no" name="trso_mssl_no"></div>                                  
                                </div>            
                              </div>
                              <i class="material-icons srstyle-cursor srstyle-inputicon btn-view-sales">link</i>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">  
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_nm">Customer:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding srstyle-boxinputicon">
                                 <input type="text" name="trso_mscs_no" class="form-control" placeholder="Select Customer" id="trso_mscs_no" value="<?php echo fset_input_customer($action, $header, ''); ?>">
                                 <button type="button" class="srstyle-cursor srstyle-inputicon" id="btn-search-customer"><i class="material-icons">search</i></button>
                              </div>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding srstyle-unchangeable" style="<?php echo ($tipe_trans == 'F') ? 'display:none' : ''; ?>">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_klas">Classification:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">            
                              <div class="srstyle-combobox">
                                <div id="trso_klas" name="trso_klas">
                                    
                                </div>                                  
                              </div>                           
                            </div>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_alamatkirim">Delivery Address:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-boxinputicon">
                              <textarea name="trso_alamatkirim" class="form-control srstyle-textarea" rows="3" id="trso_alamatkirim" placeholder="Input Delivery Address" maxlength="250"><?php echo fset_input_dlvyadd($action, $header, 'trso_alamatkirim',''); ?></textarea>
                              <button type="button" class="srstyle-cursor srstyle-inputicon" data-trigger="focus" id="btn-search-da"><i class="material-icons">search</i></button>
                            </div>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_alamatnpwp">NPWP Address:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-boxinputicon">
                              <textarea name="trso_alamatnpwp" class="form-control srstyle-textarea" rows="3" id="trso_alamatnpwp" placeholder="Input NPWP Address" maxlength="250"><?php echo fset_input_npwpadd($action, $header, 'trso_alamatnpwp',''); ?></textarea>
                              <button type="button" class="srstyle-cursor srstyle-inputicon" data-trigger="focus" id="btn-search-na"><i class="material-icons">search</i></button>
                            </div>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_cp">Contact Person:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_cp" class="form-control" placeholder="Input Contact Person" id="trso_cp" maxlength="100" value="<?php echo fset_input_value($action, $header, 'trso_cp','trsi_cp',''); ?>">
                              </div>                            
                          </div>

                          <div class="clearfix"></div>
                          <br>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_tophari">TOP/Number of Days:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" onkeypress="return fis_number(event)" name="trso_tophari" class="form-control" placeholder="Input TOP (Number of Days)" id="trso_tophari" value="<?php echo ($action == 'view') ? $header['trso_tophari'] : '' ; ?>">
                              </div>                            
                          </div>                                                                                                                       
                    </div> 
                    <!-- End container kolom -->  

                     <!-- container kolom -->
                    <div class="col-md-6 col-xs-12">
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_statusppn">Tax:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-input-area-radio">
                                <input name="trso_statusppn" type="radio" id="trso_statusppnyes" value="Y" class="radio-col-green" checked/>
                                <label for="trso_statusppnyes">Yes</label>
                                <input name="trso_statusppn" type="radio" id="trso_statusppnno" value="N" class="radio-col-green"/>
                                <label for="trso_statusppnno">No</label>            
                              </div>                              
                          </div> -->
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_kurs">Kurs:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_kurs" class="form-control auto-numeric" placeholder="Input Kurs" id="trso_kurs" value="<?php echo fset_input_value($action, $header, 'trso_kurs','trsi_kurs', $kurs); ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_pocust">Cust's PO #</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_pocust" class="form-control" placeholder="Input Cust's PO numbers" id="trso_pocust" maxlength="100" value="<?php echo fset_input_value($action, $header, 'trso_pocust','trsi_pocust',''); ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_ekspedisi">Expedition:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_ekspedisi" class="form-control" placeholder="Input Expedition" id="trso_ekspedisi" maxlength="100" value="<?php echo ($action == 'view') ? $header['trso_ekspedisi'] : '' ; ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_biayaekspedisi">Shipping Fee:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_biayaekspedisi" class="form-control auto-numeric" placeholder="Input Shipping Charges" id="trso_biayaekspedisi" value="<?php echo ($action == 'view') ? $header['trso_biayaekspedisi'] : 0 ; ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_tag">Tag:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trso_tag" class="form-control" placeholder="Input Tag" id="trso_tag" maxlength="100" value="<?php echo fset_input_value($action, $header, 'trso_tag','trsi_tag',''); ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trso_catatan">Notes SO:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding <?php echo ($action == 'view' && $header['trso_void'] == 0) ? 'srstyle-boxinputicon' : ''; ?>">
                              <textarea name="trso_catatan" class="form-control srstyle-textarea" rows="3" id="trso_catatan" placeholder="Input Notes" maxlength="250"><?php echo fset_input_notes($action, $header, 'trso_catatan','trsi_catatan',''); ?></textarea>
                              <?php
                              if($action == 'view' && $header['trso_void'] == 0){ ?>
                                <i class="material-icons srstyle-inputicon srstyle-cursor" id="btn-edit-trso_catatan" data-toggle="modal" data-target="#popup-edit-trso_catatan">create</i>
                                <?php
                              } ?>
                            </div>
                          </div>  

                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="mscs_catatan">Notes Customer (Read Only):</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                              <textarea class="form-control srstyle-textarea" rows="3" id="mscs_catatan" placeholder="" maxlength="250" readonly><?php echo $header['mscs_catatan']; ?></textarea>
                            </div>
                          </div>      
                        </br>
                        </br>
                        </br>
                        </br>
                        </br>
                        </br>
                        </br>
                        </br>        
                    </div> 
                    <!-- End container kolom -->    
                    
                    <div class="clearfix"></div>      

                    <div class="tabledetail-container col-md-12 col-sm-12 col-xs-12" style="display: none;">
                        <div class="srstyle-list-title list-title">
                          <span>Term of Payment<span>
                          <button style="<?php if($action == 'view'){echo 'display:none;';} ?>" type="button" class="btn pull-right srstyle-btntoprightdetail" id="btn-add-inputblank-top"><i class="material-icons srstyle-cursor">control_point</i></button>
                          <a style="display:none;" id="btn-cancel-edittop" href="" class="pull-right srstyle-btn-texttop"><span class="glyphicon glyphicon-remove"></span> Cancel</a>
                          <a style="display:none;" id="btn-save-top" href="javascript:void(0);" class="pull-right srstyle-btn-texttop"><span class="glyphicon glyphicon-saved"></span> Save</a>                          
                          
                          <?php 
                          if(fcek_hak_akses('.CB2.')) { ?>
                            <button style="<?php if($action == 'new'){echo 'display:none;';} ?>" type="button" class="btn pull-right srstyle-btntoprightdetail" id="btn-edit-top"><i class="material-icons srstyle-cursor">create</i></button>
                            <?php
                          } ?>
                          
                        </div>                                                       

                        <div class="srstyle-col-contenttop">
                            <table class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <thead>                                   
                                    <tr class="filters">                    
                                        <th style="display:none;">Seq</th>                                                       
                                        <th>Tgl Jatuh Tempo</th>
                                        <th>Value(%)</th>                                                       
                                        <th>Value(Rp)</th>                                                       
                                        <th>Notes</th>
                                        <th style="<?php echo (!fcek_hak_akses('.CBA.')) ? 'display:none': ''; ?>">Aktif</th>
                                        <th style="width:50px;">Action</th>                   
                                    </tr>  
                                </thead>
                                <tbody id="top-datadetail-tbody">
                                    <?php 
                                    if($action == 'view'){ 
                                        if(isset($top_so)){
                                          foreach ($top_so as $value) { ?>
                                              <tr>                                                                
                                                  <td style="display:none;"><input type="text" name="top_so[tpso_seq][]" class="form-control tpso_seq max_seq_top" value="<?php echo $value['tpso_seq']; ?>"/></td>
                                                  <td><input type="text" name="top_so[tpso_tgljatuhtempo][]" class="form-control tpso_tgljatuhtempo datepicker srstyle-ta-center" value="<?php echo $value['tpso_tgljatuhtempo']; ?>"/></td>
                                                  <td><input type="text" class="form-control tpso_persen srstyle-ta-right auto-numeric" data-trigger="focus" value=""/></td>
                                                  <td><input type="text" name="top_so[tpso_value][]" class="form-control tpso_value srstyle-ta-right auto-numeric" data-trigger="focus" value="<?php echo $value['tpso_value']; ?>"/></td>
                                                  <td><input type="text" name="top_so[tpso_cttn][]" class="form-control tpso_cttn" maxlength="250" value="<?php echo $value['tpso_cttn']; ?>"/></td>
                                                  <td style="<?php echo (!fcek_hak_akses('.CBA.')) ? 'display:none': ''; ?>">
                                                    <select class="form-control tpso_aktif" name="top_so[tpso_aktif][]">                                                        
                                                        <option value="Y" <?php echo ($value['tpso_aktif'] == 'Y') ? 'selected' : ''; ?>>Yes</option>          
                                                        <option value="N" <?php echo ($value['tpso_aktif'] == 'N') ? 'selected' : ''; ?>>No </option>         
                                                    </select>
                                                  </td>
                                                  <td style="text-align: center;"><button type="button" class="cursor srstyle-btndelete-topso btn-delete-top btn cursor" style="background-color:transparent; box-shadow:none; padding:0px;"><i class="material-icons" style>remove_circle_outline</i></button></td>                                                  
                                              </tr><?php 
                                          }
                                       }
                                    } ?>
                              </tbody>
                            </table>
                        </div>
                    </div>                    

                    <!-- ========================================== Sales Order Detail ==================================== -->
                    <div class="tabledetail-container col-md-12 col-sm-12 col-xs-12">
                        <div class="srstyle-list-title list-title">
                          <span>Detail Sales Order<span>                          
                          <button type="button" class="btn pull-right srstyle-btntoprightdetail" id="btn-search-produk"><i class="material-icons srstyle-cursor">search</i></button>
                          <button type="button" class="btn pull-right srstyle-btntoprightdetail" id="btn-search-paketproduk"><i class="material-icons srstyle-cursor">pages</i></button>
                          <!-- <button type="button" class="btn pull-right srstyle-btntoprightdetail" id="btn-view-jurnal"><i class="material-icons srstyle-cursor">chrome_reader_mode</i></button> -->
                        </div>
                        
                        <div class="srstyle-col-view">
                            <table>
                                <thead class="filters">             
                                    <th class="srstyle-ta-center">Total (Rp)</th>
                                    <th colspan="2" class="srstyle-ta-center">Action</th>
                                </thead>
                                <tbody id="salesorder-action-tbody">
                                      <?php 
                                      if($action == 'new_import' || $action == 'view'){                                      
                                          if(isset($detail)){
                                              foreach ($detail as $value) { ?>
                                                <tr>
                                                  <td>
                                                      <input style="width: 150px;" type="text" class="form-control dtso_total srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_nett'] * $value['dtsi_qty'] : $value['dtso_nett'] * $value['dtso_qty']); ?>" readonly/></td>
                                                      <td style="text-align: center;">
                                                         <button type="button" class="btn-view-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail" valign="middle"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="link">link</i></button>
                                                      </td> 

                                                      <td style="text-align: center;">
                                                         <button type="button" style="<?php if($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K'){echo 'visibility:hidden;';} ?>" class="btn-delete-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail" valign="middle"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="remove">remove_circle_outline</i></button>
                                                      </td>
                                                </tr>
                                                <?php 

                                              } ?>      
                                 
                                                <tr id="dtso_row_total">                                        
                                                    <td><input style="width:150px;" type="text" name="trso_total" id="dtso_total" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                </tr><?php
                                          }
                                      } ?>          
                                </tbody>
                            </table>
                        </div>                        

                          <div class="srstyle-col-content" id="wrap">
                              <table id=fixTable class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <thead>                                   
                                      <tr class="filters">                                                          
                                          <th style="min-width:100px;" class="produk_id">Product ID</th>
                                          <td class="produknamecol" style="background-color: white; text-align: center;"><b>&nbsp; &nbsp;  &nbsp;  &nbsp;  Product Name &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp;  </b></td>
                                          <th style="min-width:100px;">Available</th>
                                          <th class="srstyle-bgcolorqty" style="min-width:100px;">Qty</th>                                                                                    
                                          <th style="min-width:100px;">Delivered</th>                                          
                                          <th style="min-width:130px;">Currency</th>                                                       
                                          <th style="min-width:130px;">Price (USD/RP)</th>
                                          <th style="min-width:130px;">Price (RP)</th>
                                          <th style="min-width:60px;">% 1</th>          
                                          <th style="min-width:60px;">% 2</th>
                                          <th style="min-width:60px;">% 3</th>                                                 
                                          <th style="min-width:130px;">Disc (Rp)</th>                                          
                                          <th style="min-width:130px;">Before Tax (Rp)</th>
                                          <th style="min-width:130px;">Tax (Rp)</th>
                                          <th style="min-width:130px;">Nett (Rp)</th>
                                          <th style="display:none;">Seq</th>
                                          <th style="display:none;">mdpp_no</th>
                                          <th style="display:none;">seq paket</th>
                                          <th style="display:none;">status paket</th>
                                          <th style="display:none;">minprice</th>
                                          <th style="display:none;;">User approve</th>
                                          <th style="display:none;">Status Inventory</th>                                                            
                                          <th style="display:none;">Required Serial No</th>                                          
                                      </tr> 
                                  </thead>
                                  <tbody id="salesorder-datadetail-tbody">                                      
                                        <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> if new_import or view  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->
                                        <?php 
                                        if($action == 'new_import' || $action == 'view'){                                      
                                           if(isset($detail)){
                                                foreach ($detail as $value) { ?>
                                                    <tr>                                                      
                                                      <td class="produk_id"><input type="text" name="dtso[dtso_mspd_no][]" class="form-control srstyle-ta-center dtso_mspd_no dtso_mspd_no_avl" value="<?php echo (($action == 'new_import') ? $value['dtsi_mspd_no'] : $value['dtso_mspd_no'] ); ?>" <?php echo ($action == 'view' && $value['dtso_statuspaket'] != 'N') ? 'readonly':''; ?> <?php echo ($action == 'new_import' && $value['dtsi_statuspaket'] != 'N') ? 'readonly':''; ?>/></td>
                                                      <td class="produknamecol" style="background-color: #eee;"><input name="temp_dtso[mspd_nm][]" type="text" class="form-control dtso_mspd_nm" value="<?php echo $value['mspd_nm']; ?>" <?php echo ($action == 'view' && $value['dtso_statuspaket'] != 'N') ? 'readonly':''; ?> <?php echo ($action == 'new_import' && $value['dtsi_statuspaket'] != 'N') ? 'readonly':''; ?>/></td>
                                                      <td><input type="text" readonly class="form-control mspd_qtyavl srstyle-ta-right auto-numeric <?php echo (($action == 'new_import') ? $value['dtsi_mspd_no']. 'avl' : $value['dtso_mspd_no']. 'avl' ); ?>" value=""/></td>
                                                      <td>
                                                          <input type="text" name="dtso[dtso_qty][]" 
                                                          class="
                                                          form-control dtso_qty srstyle-bgcolorqty srstyle-ta-right auto-numeric
                                                          <?php if($value['dtsi_statuspaket'] == 'P' || $value['dtso_statuspaket'] == 'P'){echo 'qtypaket';} ?>
                                                          <?php if($action == 'new_import' && $value['dtsi_statuspaket'] == 'K'){ echo 'qtypaket'.$value['dtsi_seqpaket'];} ?>
                                                          <?php if($action == 'view' && $value['dtso_statuspaket'] == 'K'){ echo 'qtypaket'.$value['dtso_seqpaket'];} ?>"
                                                          value="<?php echo (($action == 'new_import') ? $value['dtsi_qty'] : $value['dtso_qty']); ?>"                                                                                                                                                                        
                                                          qty_paketitem="<?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? $value['mdpp_qty'] : 0; ?>"
                                                          <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K' || $value['mspd_reqserialno'] == 'Y') ? 'readonly':''; ?> />
                                                      </td>
                                                      <td><input type="text" readonly class="form-control srstyle-ta-right dtso_qtykirim auto-numeric" value="<?php echo ($action == 'view') ? $value['dtso_qtykirim']: '0'; ?>"/></td>
                                                      <td><input type="text" name="dtso[dtso_curr][]" class="form-control dtso_curr srstyle-ta-center" value="<?php echo ($action == 'new_import') ? $value['dtsi_curr'] : $value['dtso_curr']; ?>" readonly/></td>
                                                      <td><input type="text" name="dtso[dtso_pricelistcurr][]" class="form-control dtso_pricelistcurr srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_pricelistcurr'] : $value['dtso_pricelistcurr']); ?>" readonly/></td>
                                                      <td><input type="text" name="dtso[dtso_pricelist][]" class="form-control dtso_pricelist srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_pricelist'] : $value['dtso_pricelist']); ?>" readonly/></td>
                                                      <td><input type="text" name="dtso[dtso_discpersen1][]" class="form-control dtso_discpersen1 srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_discpersen1'] : $value['dtso_discpersen1']); ?>" mskt_discnonagen1="<?php echo $value['mskt_discnonagen1']; ?>" mskt_discagen1="<?php echo $value['mskt_discagen1']; ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>
                                                      <td><input type="text" name="dtso[dtso_discpersen2][]" class="form-control dtso_discpersen2 srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_discpersen2'] : $value['dtso_discpersen2']); ?>" mskt_discnonagen2="<?php echo $value['mskt_discnonagen2']; ?>" mskt_discagen2="<?php echo $value['mskt_discagen2']; ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>
                                                      <td><input type="text" name="dtso[dtso_discpersen3][]" class="form-control dtso_discpersen3 srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_discpersen3'] : $value['dtso_discpersen3']); ?>" mskt_discnonagen3="<?php echo $value['mskt_discnonagen3']; ?>" mskt_discagen3="<?php echo $value['mskt_discagen3']; ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>
                                                      <td><input type="text" name="dtso[dtso_discrp][]" class="form-control dtso_discrp srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_discrp'] : $value['dtso_discrp']); ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>                                                                                                            
                                                      <td><input type="text" name="dtso[dtso_bftax][]" class="form-control dtso_bftax srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_bftax'] : $value['dtso_bftax']); ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>
                                                      <td><input type="text" name="dtso[dtso_tax][]" class="form-control dtso_tax srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_tax'] : $value['dtso_tax']); ?>" readonly/></td>                                                      
                                                      <td><input type="text" name="dtso[dtso_nett][]" class="form-control dtso_nett srstyle-ta-right auto-numeric" value="<?php echo (($action == 'new_import') ? $value['dtsi_nett'] : $value['dtso_nett']); ?>" <?php echo ($value['dtsi_statuspaket'] == 'K' || $value['dtso_statuspaket'] == 'K') ? 'readonly':''; ?>/></td>                                                    
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_seq][]" class="form-control dtso_seq max_seq_dt" value="<?php echo (($action == 'new_import') ? $value['dtsi_seq'] : $value['dtso_seq'] ); ?>"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_mdpp_no][]" class="form-control dtso_mdpp_no" value="<?php echo (($action == 'new_import') ? $value['dtsi_mdpp_no'] : $value['dtso_mdpp_no'] ); ?>"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_seqpaket][]" readonly class="form-control srstyle-ta-right dtso_seqpaket 
                                                        <?php echo ($action == 'view' && $value['dtso_statuspaket'] != 'K') ? 'seqpaket':''; ?>
                                                        <?php echo ($action == 'new_import' && $value['dtsi_statuspaket'] != 'K') ? 'seqpaket':''; ?>" value="<?php echo ($action == 'new_import') ? $value['dtsi_seqpaket'] : $value['dtso_seqpaket']; ?>"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_statuspaket][]" readonly class="form-control srstyle-ta-right dtso_statuspaket" value="<?php echo ($action == 'new_import') ? $value['dtsi_statuspaket'] : $value['dtso_statuspaket']; ?>"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_minprice][]" class="form-control dtso_minprice srstyle-ta-right auto-numeric" value="0"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[dtso_msus_no][]" class="form-control dtso_msus_no srstyle-ta-center" value="" /></td>
                                                      <td style="display:none;"><input type="text" class="form-control mskt_statusinv srstyle-ta-center" value="<?php echo $value['mskt_statusinv']; ?>"/></td>
                                                      <td style="display:none;"><input type="text" name="dtso[mspd_reqserialno][]" class="form-control mspd_reqserialno srstyle-ta-center" value="<?php echo $value['mspd_reqserialno']; ?>"/></td>
                                                  </tr><?php 
                                                } ?>

                                                  <tr id="dtso_row_total" class="srstyle-rowcountdetail">
                                                      <td colspan="4" style="display:none;"></td>
                                                      <td colspan="11" class="srstyle-detailcount-label">Total</td>
                                                      <td><input type="text" id="dtso_bftaxtotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                      <td><input type="text" id="dtso_taxtotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                      <td><input type="text" id="dtso_netttotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                  </tr><?php 
                                            } 
                                        } ?>                  
                                      <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> End if new_import or view  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->     
                                  </tbody>
                              </table>
                          </div>
                      </div>
                    <!-- ========================================== End Sales Order Detail ==================================== -->
                  <div class="clearfix"></div> 
                  <!-- <input type="submit" value="submit"/> -->
              </form>                
            <!-- ========================================== End Sales Order Form ==================================== -->               
            
            </div>

            <div class="clearfix"></div>

            <br/>
            <div class="col-md-6 col-xs-12 srstyle-Remark-Text">
                <span>Require Data &nbsp;<b class="srstyle-Tanda-Harus-Diisi">*</b></span>                
                <br/>
            </div> 
            
            <div class="clearfix"></div>            
            <?php $this->load->view('v_save_bar'); ?>
        </div>                        
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="popup-lockso" role="dialog">
  <div class="modal-dialog">
  
    <!-- Modal content-->
    <div class="modal-content srstyle-confirm-box">
      <div class="modal-header srstyle-modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Confirmation</h4>
      </div>
      <div class="modal-body srstyle-comfirm-text">
        <h4>Are you sure want to lock SO?</h4>        
      </div>
      <div class="modal-footer srstyle-modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
        <button type="button" id="btn-lockso-yes" class="btn btn-default">Yes</button>
      </div>
    </div>
    
  </div>
</div>  
<!-- End Modal -->  

<!-- Modal -->
<div class="modal fade" id="popup-cancellockso" role="dialog">
  <div class="modal-dialog">
  
    <!-- Modal content-->
    <div class="modal-content srstyle-confirm-box">
      <div class="modal-header srstyle-modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Confirmation</h4>
      </div>
      <div class="modal-body srstyle-comfirm-text">
        <h4>Are you sure want to cancel lock SO?</h4>        
      </div>
      <div class="modal-footer srstyle-modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
        <button type="button" id="btn-cancellockso-yes" class="btn btn-default">Yes</button>
      </div>
    </div>
    
  </div>
</div>  
<!-- End Modal -->

<!-- Modal -->
<div class="modal fade" id="popup-edit-trso_catatan" role="dialog">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Edit Notes</h4>
      </div>
      <div class="modal-body">
        <textarea name="p_trso_catatan" class="form-control srstyle-textarea" rows="3" id="p_trso_catatan" placeholder="Input Notes" maxlength="250"></textarea>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" id="btn-save-trso_catatan" class="btn btn-default">Save</button>
      </div>
    </div>
  </div>
</div>


<?php $this->load->view('v_popup_confirm_void'); ?>
<?php $this->load->view('v_popup_confirm_print'); ?>
<?php $this->load->view('v_popup_confirm_cancel'); ?>
<?php $this->load->view('v_popup_confirm_delete'); ?>
<?php $this->load->view('v_popup_confirm_deletetop'); ?>
<?php $this->load->view('v_popup_confirm_stcopy'); ?>
<?php $this->load->view('v_popup_jurnal'); ?>
<?php $this->load->view('v_popup_confirm_approve'); ?>
<?php $this->load->view('v_popup_confirm_approvesukses'); ?>
<div id="popup-container"></div>

<!-- =====================================================Inisial=========================================== -->
<script type="text/javascript">

  var wrap = $("#wrap");

    wrap.on("scroll", function(e) {
      var scrollx = $("div.srstyle-col-content").scrollLeft();  
      if (scrollx > 132) {
        $(".produknamecol").addClass("fixed_table");
        $(".fixededit").addClass("fixedname").css("padding-left", scrollx + "px"); 
        $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
        $(".produk_id").addClass("display_id");
      } 
      else {
        $(".produknamecol").removeClass("fixed_table");
        $(".fixededit").removeClass("fixedname").css("padding-left", scrollx + "px"); 
        $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
        $(".produk_id").removeClass("display_id");
      }
    });

  $(document).ready(function(){
    function recalc_price(){
          $('.dtso_mspd_no').each(function(){
            if ($(this).val() != '') {
              var curr_row_left = $(this).parents("tr");
              var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
              var mscs_jenis = $("#mscs_jenis").val();
              fcountprice_from_discmax(curr_row_left, mscs_jenis);              
              fcountprice_from_nett(curr_row_left, curr_row_right);
            }
          });
      }
      
      var prevDate = '';

      $('#trso_tgl').datetimepicker({         
        format:'Y-m-d H:i:s',
        formatTime:'H:i',
        onShow: function(ct){
          prevDate = $('#trso_tgl').val();
          prevDate = prevDate.substr(0, 10);
        },
        onSelectDate: function(ct){
          var seldate = ct.toISOString().split('T')[0];
          var showconf = false;

          if (prevDate < '2022-04-01' && seldate >= '2022-04-01') {
            showconf = true;
          }

          if (prevDate >= '2022-04-01' && seldate < '2022-04-01') {
            showconf = true;
          }

          if (showconf) {
            falertwarning('Perubahan tanggal akan merubah tarif Tax. Sistem akan menghitung ulang harga !'); 
            recalc_price();
            fcount_total();
          }

          prevDate = $('#trso_tgl').val();
          prevDate = prevDate.substr(0, 10);
        },
      });

      $("#fixTable").tableHeadFixer({"head" : false, "left" : 2});
      var trso_statusppn = "";      

      if("<?php echo $action ?>" == "new_import"){                    
          trso_statusppn = "<?php echo $header['trso_statusppn']; ?>";                      
      }   

      if("<?php echo $action ?>" == "view"){
          trso_statusppn = "<?php echo $header['trso_statusppn']; ?>";
      }      

      if(trso_statusppn == "Y" || trso_statusppn == ""){
        $("#trso_statusppnyes").prop("checked",true);
      }else{
        $("#trso_statusppnno").prop("checked",true);
      }      

      //Set menu navigai yang sedang dipilih menjadi aktif
      $("#menu-sales-order").addClass("active");
      if("<?php echo $tipe_trans; ?>" == "F"){
          $("#menu-sales > a, #menu-sales-order > a, #menu-sales-order-f > a").addClass("toggled");
      }else{
        $("#menu-sales > a, #menu-sales-order > a, #menu-sales-order-c > a").addClass("toggled");
      }        
      $("#ml-menu-sales, #ml-menu-sales-order").css("display","block");

      var trso_klas = "<?php echo ((isset($header)) ? $header['trso_klas'] : '' ); ?>";

      trso_klas_combo = new dhtmlXCombo({
              parent: "trso_klas",
              filter: true,
              name: "trso_klas",
              items: [
                {value: "1", text: "  1", selected: trso_klas.includes("1")},
                {value: "2", text: "  2", selected: trso_klas.includes("2")},
                {value: "3", text: "  3", selected: trso_klas.includes("3")},
                {value: "4", text: "  4", selected: trso_klas.includes("4")},
                {value: "5", text: "  5", selected: trso_klas.includes("5")}
              ]
      });

      trso_klas_combo.enableFilteringMode("between");
      trso_klas_combo.setPlaceholder("Please select classification");
      trso_klas_combo.allowFreeText(false); 

        //Ajax POST untuk combo box sales
        $.ajax({
              method:"POST",
              url:"<?php echo base_url('sales/get_sales'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",
              success:function(r){                
                  var arrSales = [];                  
                  var trso_mssl_no = "";

                  if("<?php echo $action ?>" == "new_import"){                    
                      trso_mssl_no = "<?php echo $header['trsi_mssl_no']; ?>";                      
                  }   

                  if("<?php echo $action ?>" == "view"){
                      trso_mssl_no = "<?php echo $header['trso_mssl_no']; ?>";
                  }
                  
                  for (var i = 0; i < r.length; i++) {              
                      if(r[i]['mssl_aktif'] == 1 && r[i]['mssl_listmscb'].includes("<?php echo $this->session->userdata('user_aktif')['msus_mscb_no']; ?>") == true && r[i]['mssl_divisi'] == 'S'){                            
                            arrSales.push({
                                value: r[i]['mssl_no'],                  
                                text: r[i]['mssl_no'] + " : " + r[i]['mssl_nm'],
                                selected: (trso_mssl_no == r[i]['mssl_no']) ? true : false
                            });                            
                      }else{
                        if(trso_mssl_no == r[i]['mssl_no']){
                            arrSales.push({
                                value: r[i]['mssl_no'],   
                                text: r[i]['mssl_no'] + " : " + r[i]['mssl_nm'] + ' [OFF]',
                                selected: true                      
                            });                            
                        }
                      }
                  }                  
                  dhxtrsl_mssl_no = dhtmlXComboFromSelect("trso_mssl_no"); 
                  dhxtrsl_mssl_no.addOption(arrSales); 
                  dhxtrsl_mssl_no.enableFilteringMode("between");
                  dhxtrsl_mssl_no.allowFreeText(false);                  
                  dhxtrsl_mssl_no.setPlaceholder("Select Sales");

                  if("<?php echo $action ?>" == "view"){
                      dhxtrsl_mssl_no.disable();                                     
                  }
                  
                  
              }
        });        
        
        if("<?php echo $action; ?>" == "new_import"){
              vaction = "NEW";

              var tgl_si = "<?php echo $header['trsi_tgl']; ?>";
              tgl_si = tgl_si.substr(0, 10);
              var tgl_so = $('#trso_tgl').val();
              tgl_so = tgl_so.substr(0, 10);
              showconf = false;

              if (tgl_si < '2022-04-01' && tgl_so >= '2022-04-01') {
                showconf = true;
              }

              if (tgl_si >= '2022-04-01' && tgl_so < '2022-04-01') {
                showconf = true;
              }

              if (showconf) {
                falertwarning('Periode Sales Inquery dan Sales Order memiliki Tarif TAX yang berbeda! Sistem akan menghitung ulang TAX di SO ini sesuai periode SO');
                recalc_price();
              }    

              add_inputblank();              
              // $(".auto-numeric").autoNumeric("init");
              $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
              fcount_total();
              fset_info_avaliablestock();
              fcount_top();
              fcount_totaltop();
              fcount_totaltoppersen();
              $(".dtso_minprice").each(function(){
                  fcountprice_from_discmax($(this).parents('tr'), $("#mscs_jenis").val());
              });
              $(".save-bar-container").show();          
              $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-si").hide();
              $("#btn-save").attr("url:id","<?php echo base_url('sales_order/sales_order_new_simpan'); ?>");              
              $('#btn-add-inputblank-top').click();              
        }

        if("<?php echo $action; ?>" == "new"){                            
              vaction = "NEW";
              add_grandtotal();
              add_inputblank();                                          
              $(".save-bar-container").show();          
              $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-si").hide();
              $("#btn-save").attr("url:id","<?php echo base_url('sales_order/sales_order_new_simpan'); ?>");              
              $('#btn-add-inputblank-top').click();         
              $("#btn-import-si").click();     
        }

        if("<?php echo $action; ?>" == "view"){
            // $(".auto-numeric").autoNumeric("init");      
            $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});      
            if("<?php echo $header['trso_void']; ?>" == 1){
                $("#btn-void, #btn-edit, #btn-input-payment, #btn-create-sd, #btn-create-sr, #btn-print").hide();
            }                          

            $(".dtso_minprice").each(function(){
                fcountprice_from_discmax($(this).parents('tr'), $("#mscs_jenis").val());
            });

            fset_datepicker();
            fcount_total();                                   
            fset_info_avaliablestock();              
            fcount_top();
            fcount_totaltop();
            fcount_totaltoppersen();
            $("#sales_order-form :input").not(".btn-view-produk, #btn-edit-top, #btn-save-top, #btn-add-inputblank-top").prop("disabled", true);              
            $(".navbar-right").show().find("#btn-import-si").hide();
            if("<?php echo $this->session->userdata('alert_sukses'); ?>" === "sukses"){
              falertsuccess();
              <?php unset($_SESSION['alert_sukses']); ?>          
            }  
            trso_klas_combo.disable();            
        }

        // $(".auto-numeric").autoNumeric("init"); 
        $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});       
        
    });             
</script>
<!-- =====================================================End Inisial=========================================== -->

<!-- =====================================================Event=========================================== -->
<script type="text/javascript">
    var last_input_trso_mscs_no = "";
    var is_trigger_focus =true;          
    var is_trigger_mouse =false;
    var arrac_mspd_nm = [];
    var arrac_mspd_no = [];
    var curr_row_detail_left;
    var curr_row_detail_right;
    var curr_row_top;
    var temp_value;     

    // Event auto complete produk
    // VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV    
    $(document).on('blur', '.dtso_mspd_nm', function(){                                 
        var curr_row = $(this).parents("tr");                        
        var idx = curr_row.index();          
        setTimeout(function(){
          curr_row.find(".dtso_mspd_nm").val(arrac_mspd_nm[idx]);
        }, 300);                                      
    });

    $(document).on('blur', '.dtso_mspd_no', function(){
        var curr_row = $(this).parents("tr");                        
        var idx = curr_row.index();          
        setTimeout(function(){
          curr_row.find(".dtso_mspd_no").val(arrac_mspd_no[idx]);
        }, 300);                                      
    });

    $(document).on('focus', '.dtso_mspd_nm', function(){                    
        var curr_row = $(this).parents("tr");          
        var idx = curr_row.index();          
        arrac_mspd_nm[idx] = curr_row.find(".dtso_mspd_nm").val();  
        if(arrac_mspd_nm[idx] != ""){
            is_trigger_focus = false;
        }else{
            is_trigger_focus = true;
        }
    });

    $(document).on('focus', '.dtso_mspd_no', function(){                    
        var curr_row = $(this).parents("tr");          
        var idx = curr_row.index();          
        arrac_mspd_no[idx] = curr_row.find(".dtso_mspd_no").val();  
        if(arrac_mspd_no[idx] != ""){
            is_trigger_focus = false;
        }else{
            is_trigger_focus = true;
        }
    });

    $(document).on('focusout', '.dtso_mspd_nm', function(){
        var curr_row = $(this).parents("tr");          
        var idx = curr_row.index();          
        if(arrac_mspd_nm[idx] != ""){
            is_trigger_focus = false;            
        }else{
            is_trigger_focus = true;
        }
    });

    $(document).on('focusout', '.dtso_mspd_no', function(){
        var curr_row = $(this).parents("tr");          
        var idx = curr_row.index();          
        if(arrac_mspd_no[idx] != ""){
            is_trigger_focus = false;            
        }else{
            is_trigger_focus = true;
        }
    });

    $(document).on('mouseenter', '.autocomplete-suggestions', function(){
        is_trigger_mouse = true;
    });
    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^      

    $(".resume-payment-icon").click(function(){
        $(".resume-payment-box").toggle();
    });

    $(".btn-view-sales").click(function(){      
            var mssl_no = dhxtrsl_mssl_no.getSelectedValue();
            if(mssl_no !== null){
              window.open(
                "<?php echo base_url('sales/sales_view') ?>" + "/" + mssl_no,
                "_blank"
              );
            }else{
              window.open(
                "<?php echo base_url('sales') ?>",
                "_blank"
              );
            }            
    });   

    $(document).on("click",".btn-delete-produk", function(){
      curr_row_detail_right = $(this).parents('tr');
      curr_row_detail_left = $("#salesorder-datadetail-tbody tr").eq(curr_row_detail_right.index());
      $("#popup-confirm-delete").modal();
    });       
    
    $('#btn-delete-detail').click(function(){
        var dtso_seqpaket = curr_row_detail_left.find(".dtso_seqpaket").val();
        $(".dtso_seqpaket").each(function(){
            if($(this).val() == dtso_seqpaket){
              var curr_row_left = $(this).parents('tr');
              var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
              curr_row_left.remove();
              curr_row_right.remove();
            }
        });        
        
        $("#popup-confirm-delete").modal("hide");
        fcount_total();              
        fcount_top();
        fcount_totaltop();
        fcount_totaltoppersen();
    });              

    $('#btn-add-inputblank-top').click(function(){                    
          var last_row = $("#top-datadetail-tbody tr").last();
          if(last_row.find(".tpso_tgljatuhtempo").val() == '' && last_row.find(".tpso_value").val() == '' && last_row.find(".tpso_cttn").val() == ''){
              return false;
          }
          
          var row_input_blank = '<tr>'                                                                            
                                    +'<td style="display:none;"><input type="text" name="top_so[tpso_seq][]" class="form-control tpso_seq max_seq_top" value="'+ fmax_seq_top() +'"/></td>'
                                    +'<td><input type="text" name="top_so[tpso_tgljatuhtempo][]" class="form-control tpso_tgljatuhtempo datepicker srstyle-ta-center" value=""/></td>'
                                    +'<td><input type="text" class="form-control tpso_persen srstyle-ta-right auto-numeric" data-trigger="focus" value=""/></td>'
                                    +'<td><input type="text" name="top_so[tpso_value][]" class="form-control tpso_value srstyle-ta-right auto-numeric" data-trigger="focus" value=""/></td>'                                      
                                    +'<td><input type="text" name="top_so[tpso_cttn][]" class="form-control tpso_cttn" maxlength="250" value=""/></td>'
                                    +'<td style="<?php echo (!fcek_hak_akses('.CBA.')) ? 'display:none': ''; ?>">'
                                      +'<select class="form-control tpso_aktif" name="top_so[tpso_aktif][]">' 
                                          +'<option value="Y" selected>Yes</option>'
                                          +'<option value="N">No </option>'
                                      +'</select>'
                                    +'</td>'                                    
                                    +'<td style="text-align:center;"><button type="button" class="cursor srstyle-btndelete-topso btn-delete-top cursor srstyle-cursor srstyle-actdetailicon srstyle-actiondetail"><i class="material-icons" >remove_circle_outline</i></button></td>' 
                                +'</tr>';
          var last_row_index = $("#top-datadetail-tbody tr").last().index();

          if(last_row_index == -1){
            $("#top-datadetail-tbody").append(row_input_blank);
          }else{
            $("#top-datadetail-tbody tr").last().after(row_input_blank);
          }

          fset_datepicker();
          // $(".auto-numeric").autoNumeric("init");
          $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
          $(".auto-numeric").autoNumeric("update");
    });
    
    $(document).on('blur','.tpso_persen',function(){        
        var curr_row = $(this).parents("tr");        
        if($(this).val() != ""){
            var val = parseFloat(ftodouble($(this).val()));            
            // fcount_persentop(curr_row, curr_row.find(".tpso_persen").val());            
            fcount_valuetop(curr_row, curr_row.find(".tpso_persen").val());            
        }    
        fcount_totaltop();      
        fcount_totaltoppersen(); 
    });

    $(document).on('blur','.tpso_value',function(){        
        var curr_row = $(this).parents("tr");        
        if($(this).val() != ""){
            var val = parseFloat(ftodouble($(this).val()));            
            // fcount_valuetop(curr_row, curr_row.find(".tpso_value").val());            
            fcount_persentop(curr_row, curr_row.find(".tpso_value").val());            
        }    
        fcount_totaltop();
        fcount_totaltoppersen();        
    });


    // $(document).on('blur','.tpso_persen, .tpso_value',function(){
    //     $(this).popover('destroy');
    // });

    $(document).on('click','#top-datadetail-tbody .btn-delete-top',function(){      
        curr_row_top = $(this).parents("tr");
        $("#popup-confirm-deletetop").modal();  
    });

    $(document).on('click','#btn-delete-top',function(){      
        var last_row_index = $("#top-datadetail-tbody tr").last().index();              
        $("#popup-confirm-deletetop").modal("hide");
        if(last_row_index == 0){              
            var last_row = $("#top-datadetail-tbody tr").last();                
            last_row.find(".tpso_tgljatuhtempo").val("");
            last_row.find(".tpso_persen").val("");
            last_row.find(".tpso_value").val("");
            last_row.find(".tpso_cttn").val("");
            // fcount_top();
            fcount_totaltop();
            fcount_totaltoppersen();
            return false;
        }
        curr_row_top.remove();        
        // fcount_top();
        fcount_totaltop();
        fcount_totaltoppersen();
    });

    // $(document).on('click','#salesorder-action-tbody .btn-delete-produk',function(){                
    //     var curr_row_right = $(this).parent('tr');
    //     var curr_row_left = $("#salesorder-datadetail-tbody tr").eq(curr_row_right.index());
    //     curr_row_right.remove();
    //     curr_row_left.remove();
    //     fcount_total();              
    //     $(".tpso_persen").each(function(){
    //         var curr_row = $(this).parents("tr");        
    //         if($(this).val() != ""){
    //             fcount_persentop(curr_row, curr_row.find(".tpso_persen").val());
    //         }    
    //     });         
    // });                       

    $('#trso_mscs_no').devbridgeAutocomplete({
          serviceUrl: "<?php echo base_url('customer/customer_autocomplete'); ?>",
          params:{key:$("#key").val(), hash_key:$("#hash_key").val()},
          type:"POST",
          formatResult: function(suggestion, currentValue){
              return suggestion.mscs_no + ' - ' + suggestion.mscs_nm;
          }, 
          onSelect: function (suggestion) {
              last_input_trso_mscs_no = suggestion.mscs_no + ' - ' + suggestion.mscs_nm;                             

              if("<?php echo $action; ?>" == "new"){
                  var mscs_klas = suggestion.mscs_klas;
                  if(mscs_klas != '0'){
                      var index_option = trso_klas_combo.getIndexByValue(mscs_klas);
                      trso_klas_combo.selectOption(index_option, true, true);
                  }else{
                      trso_klas_combo.unSelectOption();
                  }
              }

              var mscs_cp = suggestion.mscs_cp;    
              var mscs_catatan = suggestion.mscs_catatan;    
              var mscsda_kirim_jln = suggestion.mscs_almt_jln;
              var mscsda_kirim_kota = suggestion.mscs_almt_kota;
              var mscsda_kirim_provinsi = suggestion.mscs_almt_provinsi;
              var mscs_jenis = suggestion.mscs_jenis;

              var alamat = mscsda_kirim_jln + '  ' + mscsda_kirim_kota + '  ' + mscsda_kirim_provinsi;

              $("#trso_cp").val(mscs_cp);
              $("#trso_alamatkirim").val(alamat);
              $("#trso_alamatnpwp").val(alamat);
              $("#mscs_jenis").val(mscs_jenis);
              $("#mscs_catatan").val(mscs_catatan);
              $(this).val(suggestion.mscs_no + ' - ' + suggestion.mscs_nm);

              $(".dtso_minprice").each(function(){
                  fcountprice_from_discmax($(this).parents('tr'), mscs_jenis);
              });                             
          },            
          showNoSuggestionNotice:true        
    });

    // $(document).on('blur','.dtso_mspd_no', function(){                               
    //     var curr_row = $(this).parents("tr");            
    //      if(curr_row.find(".dtso_mspd_no").val() != last_input_mspd_no){ 
    //       setTimeout(function(){                
    //           curr_row.find(".dtso_mspd_no").val(last_input_mspd_no);                  
    //       }, 300);
    //      }               
    // });

    // $(document).on('blur', '.dtso_mspd_nm', function(){           
    //       var curr_row = $(this).parents("tr");
    //       if(curr_row.find(".dtso_mspd_nm").val() != last_input_mspd_nm){
    //           setTimeout(function(){                
    //               curr_row.find(".dtso_mspd_nm").val(last_input_mspd_nm);                     
    //           }, 300);              
    //       }  
    // });


    // $(document).on('focus', '.dtso_mspd_nm, .dtso_mspd_no', function(){            
    //       var curr_row = $(this).parents("tr");
    //       last_input_mspd_no = curr_row.find(".dtso_mspd_no").val();
    //       last_input_mspd_nm = curr_row.find(".dtso_mspd_nm").val();                            
         
    //        if($(this).val() != ""){              
    //           is_produk_selected = false;                    
    //        }               
    // });

    // $(document).on('focusout', '.dtso_mspd_nm, .dtso_mspd_no', function(){            
    //       var curr_row = $(this).parents("tr");
    //       curr_row.find(".dtso_mspd_no").val(last_input_mspd_no);
    //       curr_row.find(".dtso_mspd_nm").val(last_input_mspd_nm);                                                       

    // });
        
    $(document).on('blur', '#trso_mscs_no', function(){                         
          setTimeout(function(){                
              $("#trso_mscs_no").val(last_input_trso_mscs_no);                                        
          }, 300);                                      
    });                
   
    $("#btn-search-customer").click(function(){                                                
        $("#btn-search-customer").prop("disabled", true);
        $.ajax({
            method:"POST",        
            url: "<?php echo base_url('customer/customer_popup'); ?>",
            data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
            dataType:"json",
            success:function(r){                                                          
              $("#popup-container").html(r.popup);                                                            
              $("#customerModal").modal();
              $("#btn-search-customer").prop("disabled", false);
            } 
        });                                
    });

    $("#btn-search-da").click(function(){
          var trso_mscs_no = $("#trso_mscs_no").val();            
          if(trso_mscs_no == ""){
              falertwarning("Please select customer first.");          
              return;
          }          
          $("#btn-search-da").prop("disabled", true);
          $.ajax({
              method:"POST",        
              url: "<?php echo base_url('customer/alamat_kirim_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",
              success:function(r){                                                                              
                var mscs_no = $("#trso_mscs_no").val().substring(0, 6);
                $("#popup-container").html(r.popup);                                                            
                $("[name='mscs_no']").val(mscs_no).trigger("input").prop("readonly", true);
                $("#alamat-kirim-modal").modal();
                $("#btn-search-da").prop("disabled", false);
              } 
          });                                
    });

    $("#btn-search-na").click(function(){
          var trso_mscs_no = $("#trso_mscs_no").val();            
          if(trso_mscs_no == ""){
              falertwarning("Please select customer first.");          
              return;
          }          
          $("#btn-search-na").prop("disabled", true);
          $.ajax({
              method:"POST",        
              url: "<?php echo base_url('customer/alamat_npwp_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",
              success:function(r){                                                                              
                var mscs_no = $("#trso_mscs_no").val().substring(0, 6);
                $("#popup-container").html(r.popup);                                                            
                $("[name='mscs_no']").val(mscs_no).trigger("input").prop("readonly", true);
                $("#alamat-npwp-modal").modal();
                $("#btn-search-na").prop("disabled", false);
              } 
          });                                
    });

    $("#btn-search-produk").click(function(){            
        jenis_produk = "BUKAN_PAKET";
        $("#btn-search-produk").prop("disabled", true);
        $.ajax({
              method:"POST",        
              url: "<?php echo base_url('produk/produk_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val(), tipe_trans:"<?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>", mspd_paket:"N"}, 
              dataType:"json",
              success:function(r){                                                                
                $("#popup-container").html(r.popup);                                                            
                $("#produkModal").modal();
                // $("[name=mspd_fin]").val("<?php //echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>").prop("readonly", true).trigger("input");
                $("[name=mspd_fin]").prop("readonly", true);
                // $("[name='mspd_paket']").val("N").prop("disabled", true).trigger("input");
                $("[name='mspd_paket']").prop("readonly", true);
                $("#btn-search-produk").prop("disabled", false);
              } 
        });  
    });

    $("#btn-search-paketproduk").click(function(){            
        jenis_produk = "PAKET";
        $("#btn-search-produk").prop("disabled", true);
        $.ajax({
              method:"POST",        
              url: "<?php echo base_url('produk/produk_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val(), tipe_trans:"<?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>", mspd_paket:"Y"}, 
              dataType:"json",
              success:function(r){                                                                
                $("#popup-container").html(r.popup);                                                            
                $("#produkModal").modal();
                // $("[name=mspd_fin]").val("<?php //echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>").prop("readonly", true).trigger("input");
                $("[name=mspd_fin]").prop("readonly", true);
                // $("[name='mspd_paket']").val("Y").prop("disabled", true).trigger("input");
                $("[name='mspd_paket']").prop("readonly", true);
                $("#btn-search-produk").prop("disabled", false);
              } 
        });
    });       

    $("#btn-view-jurnal").click(function(){                    
        $("#jurnal-modal").modal();                    
    }); 

    $("#btn-no").click(function(){      
      $("#popup-confirm-print").modal("hide");
      window.open("<?php echo base_url('sales_order/sales_order_print?trso_no='); ?>" + $("#trso_no").val() + "&&paper_size=A4","_blank");
    })  

    $("#btn-save-print").click(function(){      
      $("#popup-confirm-print").modal("hide");
      window.open("<?php echo base_url('sales_order/sales_order_print?trso_no='); ?>" + $("#trso_no").val() + "&&paper_size=A5","_blank");
    })

    $("#btn-print").click(function(){  
        $("#popup-confirm-print").modal();
    });    

    $("#btn-import-si").click(function(){            
        $.ajax({
              method:"POST",        
              url: "<?php echo base_url('sales_inquery/sales_inquery_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val(), tipe_trans:"<?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>"}, 
              dataType:"json",
              success:function(r){                                                                
                $("#popup-container").html(r.popup);                                                            
                $("#sales-inquery-modal").modal();
              } 
          });  
    });    

    $(document).on('dblclick','#salesinquery-datalist-tbody tr',function(){                                           
          var trsi_no = $(this).attr("data['trsi_no']");
          var trsi_fin = $(this).attr("data['trsi_fin']");
          window.location.href = "<?php echo base_url('sales_order/sales_order_new/'); ?>" + "/" + trsi_no + "/" + trsi_fin;
    });

    $(document).on('dblclick','#customer-datalist-tbody tr',function(){                                           
          var mscs_no = $(this).attr("data['mscs_no']");
          var mscs_nm = $(this).attr("data['mscs_nm']");                           
          var mscs_cp = $(this).attr("data['mscs_cp']");    
          var mscs_catatan = $(this).attr("data['mscs_catatan']");    
          var mscsda_kirim_jln = $(this).attr("data['mscs_almt_jln']");
          var mscsda_kirim_kota = $(this).attr("data['mscs_almt_kota']");
          var mscsda_kirim_provinsi = $(this).attr("data['mscs_almt_provinsi']");
          var mscs_jenis = $(this).attr("data['mscs_jenis']");          

          if("<?php echo $action; ?>" == "new"){
              var mscs_klas = $(this).attr("data['mscs_klas']");
              if(mscs_klas != '0'){
                  var index_option = trso_klas_combo.getIndexByValue(mscs_klas);
                  trso_klas_combo.selectOption(index_option, true, true);
              }else{
                  trso_klas_combo.unSelectOption();
              }
          }

          last_input_trso_mscs_no = mscs_no + ' - ' + mscs_nm; 

          var alamat = mscsda_kirim_jln + '  ' + mscsda_kirim_kota + '  ' + mscsda_kirim_provinsi;

          $("#trso_mscs_no").val(mscs_no + " - " + mscs_nm);
          $("#mscs_jenis").val(mscs_jenis);          
          $("#mscs_catatan").val(mscs_catatan);
          $("#trso_cp").val(mscs_cp);
          $("#trso_alamatkirim").val(alamat);          
          $("#trso_alamatnpwp").val(alamat);          
          $("#customerModal").modal("hide");

          $(".dtso_minprice").each(function(){
              fcountprice_from_discmax($(this).parents('tr'), mscs_jenis);
          });       
    });

    $(document).on('dblclick','#mscsda-datalist-tbody tr',function(){                                                               
        var mscsda_kirim_jln = $(this).attr("data['mscsda_kirim_jln']");
        var mscsda_kirim_kota = $(this).attr("data['mscsda_kirim_kota']");
        var mscsda_kirim_provinsi = $(this).attr("data['mscsda_kirim_provinsi']");          

        $("#trso_alamatkirim").val(mscsda_kirim_jln + '  ' + mscsda_kirim_kota + '  ' + mscsda_kirim_provinsi);          
        $("#alamat-kirim-modal").modal("hide");
    });

    $(document).on('dblclick','#mscsna-datalist-tbody tr',function(){                                                               
        var mscsna_npwp_jln = $(this).attr("data['mscsna_npwp_jln']");
        var mscsna_npwp_kota = $(this).attr("data['mscsna_npwp_kota']");
        var mscsna_npwp_provinsi = $(this).attr("data['mscsna_npwp_provinsi']");          

        $("#trso_alamatnpwp").val(mscsna_npwp_jln + '  ' + mscsna_npwp_kota + '  ' + mscsna_npwp_provinsi);
        $("#alamat-npwp-modal").modal("hide");
    });

    $(document).on('dblclick','#produk-datalist-tbody tr',function(){
        $("div.srstyle-col-content").scrollLeft("0px");
        var kurs = parseFloat(ftodouble($("#trso_kurs").val()));          
        var mscs_jenis = $("#mscs_jenis").val();

        if(jenis_produk == "BUKAN_PAKET"){
            var mskt_statusinv = $(this).attr("data['mskt_statusinv']");
            var mspd_reqserialno = $(this).attr("data['mspd_reqserialno']");
            var mspd_curr = $(this).attr("data['mspd_curr']");
            var dtso_pricelist = (mspd_curr == 'RP') ? $(this).attr("data['mspd_pricelist']") : ($(this).attr("data['mspd_pricelist']") * kurs).toFixed(4);

            var last_row_left = $("#salesorder-datadetail-tbody").find("#dtso_row_total").prev();
            var last_row_right = $("#salesorder-action-tbody tr").eq(last_row_left.index());
                last_row_left.find(".dtso_mspd_no").val($(this).attr("data['mspd_no']"));
                last_row_left.find(".dtso_mspd_nm").val($(this).attr("data['mspd_nm']"));
                last_row_left.find(".dtso_curr").val($(this).attr("data['mspd_curr']"));
                last_row_left.find(".dtso_pricelistcurr").val($(this).attr("data['mspd_pricelist']"));
                last_row_left.find(".dtso_pricelist").val(dtso_pricelist);
                
                last_row_left.find(".dtso_discpersen1").attr("mskt_discnonagen1", $(this).attr("data['mskt_discnonagen1']"));
                last_row_left.find(".dtso_discpersen2").attr("mskt_discnonagen2", $(this).attr("data['mskt_discnonagen2']"));
                last_row_left.find(".dtso_discpersen3").attr("mskt_discnonagen3", $(this).attr("data['mskt_discnonagen3']"));
            
                last_row_left.find(".dtso_discpersen1").attr("mskt_discagen1", $(this).attr("data['mskt_discagen1']"));
                last_row_left.find(".dtso_discpersen2").attr("mskt_discagen2", $(this).attr("data['mskt_discagen2']"));
                last_row_left.find(".dtso_discpersen3").attr("mskt_discagen3", $(this).attr("data['mskt_discagen3']"));
            
                last_row_left.find(".dtso_discpersen1").val(0);
                last_row_left.find(".dtso_discpersen2").val(0);
                last_row_left.find(".dtso_discpersen3").val(0);
                  
                last_row_left.find(".dtso_discrp").val(0); 
                last_row_left.find(".dtso_bftax").val(0);
                last_row_left.find(".dtso_tax").val(0);
                // last_row_left.find(".dtso_nett").val(dtso_pricelist + dtso_tax);
                last_row_left.find(".dtso_nett").val(dtso_pricelist);
                last_row_left.find(".mspd_qtyavl").addClass($(this).attr("data['mspd_no']") + "avl");                
                last_row_left.find(".dtso_qtykirim").val(0); 
                last_row_left.find(".dtso_qty").val(1);            
                
                last_row_left.find(".mskt_statusinv").val(mskt_statusinv);
                last_row_left.find(".mspd_reqserialno").val(mspd_reqserialno);
                if(last_row_left.find(".dtso_seq").val() == ""){
                  last_row_left.find(".dtso_seq").val(fmax_seq_dt());
                }
                if(last_row_left.find(".dtso_seqpaket").val() == ""){
                  last_row_left.find(".dtso_seqpaket").val(fmax_seqpaket());
                }
                last_row_left.find(".dtso_statuspaket").val("N");
                last_row_right.find(".btn-delete-produk").css("visibility","visible");
                last_row_right.find(".btn-view-produk").css("visibility","visible");
                                      
                if($(this).attr("data['mspd_reqserialno']") == 'Y'){                
                    last_row_left.find(".dtso_qty").attr("readonly", true);
                }      

            fcountprice_from_discmax(last_row_left, mscs_jenis);
            // fcountprice_from_discount(last_row_left, last_row_right);
            fcountprice_from_nett(last_row_left, last_row_right);
            add_inputblank();                     
            fcount_total();
            fautocomplete();        
            fset_info_avaliablestock();
            fcount_top();
            fcount_totaltop();
            fcount_totaltoppersen();
        }

        if(jenis_produk == "PAKET"){
              var vmdpp_no = $(this).attr("data['mspd_no']");              

              $.ajax({
                    method:"POST",        
                    url: "<?php echo base_url('produk/produk_paket'); ?>",
                    data:{mdpp_no:vmdpp_no, key:$("#key").val(), hash_key:$("#hash_key").val()}, 
                    dataType:"json",
                    success:function(r){
                        var inputreadonly = '';
                        var pricelist = 0;                        
                        var pricelistcurr = 0;                        
                        var tax = 0;
                        var nett = 0;
                        var visibility;
                        var dtso_statuspaket;
                        var class_seqpaket;
                        var dtso_seqpaket;
                        var class_qtypaket;

                        for (var i=0; i < r.length; i++) {                                                        
                            if(i == 0){
                              var mspd_curr =  r[i]['mspd_curr'];                              
                              pricelistcurr = r[i]['mspd_pricelist'];                              
                              pricelist = (mspd_curr == 'RP') ? r[i]['mspd_pricelist'] : r[i]['mspd_pricelist'] * kurs;
                              
                              visibility = "visibility:visible;";
                              dtso_statuspaket = "P"
                              class_seqpaket = "seqpaket";
                              dtso_seqpaket = fmax_seqpaket();
                              inputreadonly = '';
                              class_qtypaket = 'qtypaket';
                            }else{
                              pricelistcurr = 0;                        
                              pricelist = 0;
                              tax = 0;
                              nett = 0;                              
                              visibility = "visibility:hidden;";
                              dtso_statuspaket = "K";
                              dtso_seqpaket = dtso_seqpaket;
                              inputreadonly = 'readonly';
                              class_seqpaket = "";
                              class_qtypaket = 'qtypaket' + dtso_seqpaket;
                            }

                            var row_input_blank_left = '<tr>'                                        
                                                          +'<td class="produk_id"><input type="text" placeholder="search ID" name="dtso[dtso_mspd_no][]" class="form-control srstyle-ta-center dtso_mspd_no dtso_mspd_no_avl" value="'+ r[i]['mspd_no'] +'" readonly/></td>'
                                                          +'<td class="fixededit"><input type="text" name="temp_dtso[mspd_nm][]" placeholder="search Product" class="form-control dtso_mspd_nm" value="'+ r[i]['mspd_nm'] +'" readonly/></td>'
                                                          +'<td><input type="text" readonly class="form-control mspd_qtyavl srstyle-ta-right auto-numeric '+ r[i]['mspd_no'] + 'avl " value=""/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_qty][]" class="form-control dtso_qty srstyle-bgcolorqty srstyle-ta-right auto-numeric '+ class_qtypaket +'" value="'+ r[i]['mdpp_qty'] +'" qty_paketitem="'+ r[i]['mdpp_qty'] +'" '+ inputreadonly +'/></td>'                                      
                                                          +'<td><input type="text" readonly class="form-control srstyle-ta-right dtso_qtykirim auto-numeric" value="0"/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_curr][]" class="form-control dtso_curr srstyle-ta-center" value="'+ r[i]['mspd_curr'] +'" readonly/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_pricelistcurr][]" class="form-control dtso_pricelistcurr srstyle-ta-right auto-numeric" value="'+ pricelistcurr +'" readonly/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_pricelist][]" class="form-control dtso_pricelist srstyle-ta-right auto-numeric" value="'+ pricelist +'" readonly/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_discpersen1][]" class="form-control dtso_discpersen1 srstyle-ta-right auto-numeric" value="0" '+ inputreadonly +' mskt_discnonagen1="'+ r[i]['mskt_discnonagen1'] +'" mskt_discagen1="'+ r[i]['mskt_discagen1'] +'"/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_discpersen2][]" class="form-control dtso_discpersen2 srstyle-ta-right auto-numeric" value="0" '+ inputreadonly +' mskt_discnonagen2="'+ r[i]['mskt_discnonagen2'] +'" mskt_discagen2="'+ r[i]['mskt_discagen2'] +'"/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_discpersen3][]" class="form-control dtso_discpersen3 srstyle-ta-right auto-numeric" value="0" '+ inputreadonly +' mskt_discnonagen3="'+ r[i]['mskt_discnonagen3'] +'" mskt_discagen3="'+ r[i]['mskt_discagen3'] +'"/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_discrp][]" class="form-control dtso_discrp srstyle-ta-right auto-numeric" value="0" '+ inputreadonly +'/></td>'                                                                                                  
                                                          +'<td><input type="text" name="dtso[dtso_bftax][]" class="form-control dtso_bftax srstyle-ta-right auto-numeric" value="0" '+ inputreadonly +'/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_tax][]" class="form-control dtso_tax srstyle-ta-right auto-numeric" value="0" readonly/></td>'
                                                          +'<td><input type="text" name="dtso[dtso_nett][]" class="form-control dtso_nett srstyle-ta-right auto-numeric" value="'+ pricelist +'" '+ inputreadonly +'/></td>'                                   
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_seq][]" class="form-control dtsi_seq max_seq_dt" value="'+ fmax_seq_dt() +'"/></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_mdpp_no][]" class="form-control dtso_mdpp_no" value="'+ r[i]['mdpp_no'] +'"/></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_seqpaket][]" readonly class="form-control srstyle-ta-right seqpaket dtso_seqpaket '+ class_seqpaket +'" value="'+ dtso_seqpaket +'"/></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_statuspaket][]" readonly class="form-control srstyle-ta-right dtso_statuspaket" value="'+ dtso_statuspaket +'"/></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_minprice][]" class="form-control dtso_minprice srstyle-ta-right auto-numeric" value="" /></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[dtso_msus_no][]" class="form-control dtso_msus_no srstyle-ta-center" value="" /></td>'
                                                          +'<td style="display:none;"><input type="text" class="form-control mskt_statusinv srstyle-ta-center" value=""/></td>'
                                                          +'<td style="display:none;"><input type="text" name="dtso[mspd_reqserialno][]" class="form-control mspd_reqserialno srstyle-ta-center" value="'+ r[i]['mspd_reqserialno'] +'"/></td>'                       
                                                      +'</tr>';

                            var row_input_blank_right = '<tr>'
                                                        +'<td><input style="width:150px;" type="text" class="form-control dtso_total srstyle-ta-right auto-numeric" value="'+ pricelist +'" readonly/></td>' 

                                                         +'<td style="text-align:center;" ><button type="button" class="btn-view-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="link">link</i></button></td>'  

                                                        +'<td style="text-align:center;" class="btn-delete-produk"><button type="button" style="'+ visibility +'" class="btn-delete-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="remove">remove_circle_outline</i></button></td>'

                                                        +'</tr>';
                            
                            $("#salesorder-datadetail-tbody").find("#dtso_row_total").prev().before(row_input_blank_left);
                            $("#salesorder-action-tbody").find("#dtso_row_total").prev().before(row_input_blank_right);
                            
                            if(i == 0){
                              var curr_row_left = $("#salesorder-datadetail-tbody").find("#dtso_row_total").prev().prev();                              
                              var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
                              fcountprice_from_discmax(curr_row_left, mscs_jenis);
                              fcountprice_from_nett(curr_row_left, curr_row_right);
                            }

                        }

                        fcount_total();
                        fset_info_avaliablestock(); 
                        fcount_top();
                        fcount_totaltop();
                        fcount_totaltoppersen();
                        fautocomplete();          
                        // $(".auto-numeric").autoNumeric("init");       
                        $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
                        $(".auto-numeric").autoNumeric("update");   
                    }
              });
          }
        $("#produkModal").modal("hide");
    });
    
    $(document).on('focus','.dtso_discpersen1, .dtso_discpersen2, .dtso_discpersen3, .dtso_discrp, .dtso_qty, .dtso_bftax, .dtso_tax, .dtso_nett, #trso_kurs',function(){
        temp_value = $(this).val();
    });
      
    $(document).on('blur','.dtso_discpersen1, .dtso_discpersen2, .dtso_discpersen3, .dtso_discrp',function(){
          if(temp_value == $(this).val()){
            return false;
          }  

          var curr_row_left = $(this).parents('tr');
          var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());

          fcountprice_from_discount(curr_row_left, curr_row_right);          
          fcount_total(); 
          fcount_top();
          fcount_totaltop();
          fcount_totaltoppersen();
          // $(".tpso_persen").each(function(){
          //     var curr_row = $(this).parents("tr");        
          //     if($(this).val() != ""){
          //         // fcount_persentop(curr_row, curr_row.find(".tpso_persen").val());
          //         fcount_valuetop(curr_row, curr_row.find(".tpso_persen").val());
          //     }    
          // });
    });

    $(document).on('blur','.dtso_qty',function(){
          if(temp_value == $(this).val()){
            return false;
          }  

          var curr_row_left = $(this).parents('tr');
          var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());

          fcountprice_from_qty(curr_row_left, curr_row_right);          
          fcount_total(); 
          fcount_top();
          fcount_totaltop();
          fcount_totaltoppersen();
          // $(".tpso_persen").each(function(){
          //     var curr_row = $(this).parents("tr");        
          //     if($(this).val() != ""){
          //         // fcount_persentop(curr_row, curr_row.find(".tpso_persen").val());
          //         fcount_valuetop(curr_row, curr_row.find(".tpso_persen").val());
          //     }    
          // });
    });

    $(document).on('blur','.qtypaket',function(){
          var curr_row = $(this).parents('tr');
          var dtso_seqpaket = curr_row.find(".seqpaket").val();
          var dtso_qty = $(this).val();
          $(".qtypaket" + dtso_seqpaket).each(function(){
              var qty_paketitem = $(this).attr("qty_paketitem");              
              $(this).autoNumeric("set", qty_paketitem * dtso_qty);
          });
    });
         
    $(document).on('blur','.dtso_nett',function(){
        if(temp_value == $(this).val()){
          return false;
        }  

        var curr_row_left = $(this).parents('tr');
        var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
        fcountprice_from_nett(curr_row_left, curr_row_right);
        fcount_total();
        fcount_top();
        fcount_totaltop();
        fcount_totaltoppersen();
    });

    $(document).on('blur','.dtso_bftax',function(){              
        if(temp_value == $(this).val()){
          return false;
        }

        var curr_row_left = $(this).parents('tr');
        var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
        fcountprice_from_bftax(curr_row_left, curr_row_right);
        fcount_total();
        fcount_top();
        fcount_totaltop();
        fcount_totaltoppersen();   
    }); 

     $(document).on("click",".btn-view-produk"  , function(){
         var curr_row_right = $(this).parents('tr');
         var curr_row_left = $("#salesorder-datadetail-tbody tr").eq(curr_row_right.index());
          var dtso_mspd_no = curr_row_left.find('.dtso_mspd_no').val();
          if(dtso_mspd_no !== ''){
            window.open(
              "<?php echo base_url('produk/produk_view') ?>" + "/" + dtso_mspd_no,
              "_blank"
            );
          }else{
            window.open(
              "<?php echo base_url('produk') ?>",
              "_blank"
            );
          }
    });
   
    //Redirect ke sales_order list
    $("#btn-cancel-detail").click(function(){
        window.location.href = "<?php echo base_url('sales_order'); ?>";
    });

    $("#btn-cancel").click(function(){
        $('#popup-confirm-cancel').modal();
    });
      
    //Event edit sales_order
    $(document).on('click','#btn-edit',function(){
        vaction = "EDIT";
        var last_row_indexdt = $("#salesorder-datadetail-tbody tr").index();
        var last_row_indextop = $("#top-datadetail-tbody tr").index();
        dhxtrsl_mssl_no.enable();                             
        $("#sales_order-form :input").not("#trso_tgl").prop("disabled", false);
        $(".save-bar-container").show();
                
        if(last_row_indexdt == -1){
            add_grandtotal();
        }
        if(last_row_indextop == -1){
           $('#btn-add-inputblank-top').click();
        }        
        add_inputblank();
    });

    $(document).on('click','#btn-edit-top',function(){                    
        var last_row_indextop = $("#top-datadetail-tbody tr").index();
        if(last_row_indextop == -1){
         $('#btn-add-inputblank-top').click();
        }
        $(this).hide();
        $("#btn-add-inputblank-top, #btn-save-top, #btn-cancel-edittop").css("display", 'block');
        $("#top-datadetail-tbody input[type=text], #top-datadetail-tbody button[type=button], #top-datadetail-tbody select").prop("disabled", false);
    });

    $(document).on('click','#btn-save-top',function(){
        var arr_tpso_seq = $(".tpso_seq").serializeArray(); 
        var arr_tpso_tgljatuhtempo = $(".tpso_tgljatuhtempo").serializeArray();
        var arr_tpso_value = $(".tpso_value").serializeArray();
        var arr_tpso_cttn = $(".tpso_cttn").serializeArray();
        var arr_tpso_aktif = $(".tpso_aktif").serializeArray();                
        var arr_top = []; 
        var obj = {}

        for (var i = 0; i < arr_tpso_seq.length; i++) {
          if(arr_tpso_tgljatuhtempo[i].value != '' || arr_tpso_value[i].value != '' || arr_tpso_cttn[i].value != ''){
            obj['tpso_seq'] = arr_tpso_seq[i].value;     
            obj['tpso_tgljatuhtempo'] = arr_tpso_tgljatuhtempo[i].value;            
            obj['tpso_value'] = ftodouble(arr_tpso_value[i].value);            
            obj['tpso_cttn'] = arr_tpso_cttn[i].value;            
            obj['tpso_aktif'] = arr_tpso_aktif[i].value;               
            arr_top.push(obj);
            obj = {}
          }
        };      

        $.ajax({
              url: "<?php echo base_url('sales_order/top_so_simpan'); ?>",
              data: {top_so:arr_top, trso_no:$("#trso_no").val(), trso_cekint:$("#trso_cekint").val(), key:$("#key").val(), hash_key:$("#hash_key").val()},
              type: 'POST',
              dataType:"json",      
              success: function(result){
                  var errmsg="";
                  if (result.response == "gagal") {               
                      $.each(result.error_message, function (index, value) {
                        errmsg += value;                            
                      });
                      falertwarning(errmsg);                   
                  }else{                                                                               
                      window.location.href = "<?php echo base_url('sales_order/sales_order_view'); ?>" + "/" + result.trso_no;
                  }                       
              },
              error:function(){
                falertwarning('Error query or syntax');              
              }
        });
    });

    $("#btn-void").click(function(){          
        $("#popup-confirm-void").modal();
    });

    $("#stcopy").click(function(){          
        var stcopy = $(this).text().trim();      
        if(stcopy == "R" || stcopy == "X"){
          $("#popup-confirm-stcopy").modal();
        }
    });
        
    $("#btn-save-void").click(function(){                      
        vaction = "VOID";
        save_data();
    });

    $("#btn-stcopy-yes").click(function(){
        vaction = "STCOPY";
        save_data();
    }); 
                                   
    //Save sales_order ke database
    $("#btn-save").click(function(){
        save_data();
    });    

    function save_data(){  
        $("#sales_order-form :input").prop("disabled",false);
        trso_klas_combo.enable()
        $("#trso_tgl").prop('disabled',false);
        $("#btn-save").prop('disabled',true);
        $("#btn-save-void").prop('disabled',true);
        $("#btn-stcopy-yes").prop('disabled',true);
        $("#sales_order-form").ajaxSubmit({
              url: "<?php echo base_url('sales_order/sales_order_simpan'); ?>",
              data:{action:vaction},
              type: 'POST',
              dataType:"json",      
              success: function(result){
                  var errmsg="";
                  if (result.response == "gagal") {               
                      $.each(result.error_message, function (index, value) {
                        errmsg += value;                            
                      });
                      falertwarning(errmsg);   
                      if("<?php echo $action; ?>" == "view"){                     
                          trso_klas_combo.disable();                   
                      }
                      $("#trso_nm").focus();
                      $("#btn-save, #btn-save-void, #btn-stcopy-yes").prop('disabled',false);
                      $("#popup-confirm-void").modal('hide');
                      $("#popup-confirm-stcopy").modal("hide");

                      if(vaction != "NEW"){  
                        $("#trso_tgl").prop('disabled',true);
                      }
                      
                      if(vaction == "VOID"){
                        $("#sales_order-form :input").prop("disabled",true);
                      }
                  }else if(result.response == "perlu_acc"){
                        if("<?php echo $action; ?>" == "view"){                     
                            trso_klas_combo.disable();                   
                        }
                        $("#err_msg_otorisasi").html("");
                        $.each(result.error_message, function (index, value) {
                          errmsg += value;                            
                        });
                        $("#btn-save").prop('disabled',false);                        
                        $("#err_msg_underminprice").html(errmsg);
                        $("#popup-confirm-approve").modal();
                  }else{                                                    
                      window.location.href = "<?php echo base_url('sales_order/sales_order_view'); ?>" + "/" + result.trso_no;
                  }                       
              },
              error:function(){
                falertwarning('Error query or syntax');
                $("#popup-confirm-void").modal("hide");
                $("#popup-confirm-stcopy").modal("hide");
              }
        });          
    }

    $("#btn-approve-underminprice").click(function(){
          var vjenis_otorisasi = $("input[name='jenis_otorisasi']:checked").val();
          $.ajax({
                url: "<?php echo base_url('sales_order/approve_underminprice'); ?>", 
                data:{msus_nm:$("#msus_nm").val(), msus_pswd:$("#msus_pswd").val(), jenis_otorisasi:vjenis_otorisasi, key_otorisasi:$("#key_otorisasi").val(), user_otorisasi:$("#user_otorisasi").val(), kode_otorisasi:$("#kode_otorisasi").val(), key:$("#key").val(), hash_key:$("#hash_key").val()},
                type: 'POST',
                dataType:"json",      
                success: function(result){         
                    $("#msus_nm").val("");
                    $("#msus_pswd").val("");
                    $("#user_otorisasi").val("");
                    $("#kode_otorisasi").val("");
                    if(result.response == "gagal"){                      
                      $("#err_msg_otorisasi").html(result.error_message);
                      $("#key_otorisasi").val(result.mt_rand);
                    }else{
                      $(".dtso_minprice").each(function(){
                          var curr_row = $(this).parents("tr");
                          var minprice = parseFloat(ftodouble($(this).val()));
                          var bftax = parseFloat(ftodouble(curr_row.find(".dtso_bftax").val()));

                          if(bftax < minprice){
                            curr_row.find(".dtso_msus_no").val(result.msus_no);
                          }              
                      });
                      $("#popup-confirm-approve").modal("hide");
                      $("#popup-confirm-approvesukses").modal();
                    }

                },
                error:function(){
                  falertwarning('Error query or syntax');
                }
          });    
      });

    $("#btn-create-sd").click(function(){        
        window.location.href = "<?php echo base_url('sales_delivery/sales_delivery_new'); ?>" + "/" + $("#trso_no").val();
    });       

    $("#btn-create-sr").click(function(){        
        window.location.href = "<?php echo base_url('sales_retur/sales_retur_new'); ?>" + "/" + $("#trso_no").val();
    });       

    $("#btn-input-payment").click(function(){        
        window.location.href = "<?php echo base_url('so_payment/so_payment_new'); ?>" + "/" + $("#trso_no").val();
    });       

    // $("div.srstyle-col-content").scroll(function(){
    //     var scrollx = $("div.srstyle-col-content").scrollLeft() + 10;  
    //     $("td.srstyle-detailcount-label").css("padding-left", scrollx +"px"); 

    //     // $("#fixTable").tableHeadFixer({"head" : false, "left" : 4}); 
    // });

    
    $("#trso_kurs").blur(function(){
        if(temp_value == $(this).val()){
          return false;
        }  
                       
        var kurs = parseFloat(ftodouble($("#trso_kurs").val()));        
        var mscs_jenis = $("#mscs_jenis").val();

        $(".dtso_curr").each(function(){            
            var curr_row_left = $(this).parents("tr");                          
            var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
            var mspd_pricelist = parseFloat(ftodouble(curr_row_left.find(".dtso_pricelistcurr").val()));
            if($(this).val() == 'USD'){
                var pricelist =  (mspd_pricelist * kurs).toFixed(4);
                curr_row_left.find(".dtso_pricelist").autoNumeric("set", pricelist);
                curr_row_left.find(".dtso_nett").autoNumeric("set", pricelist);
                // fcountprice_from_discount(curr_row_left, curr_row_right);
                fcountprice_from_nett(curr_row_left, curr_row_right);
                fcountprice_from_discmax(curr_row_left, mscs_jenis);
            }
        }); 

        fcount_total();
        fcount_top();
        fcount_totaltop();
        fcount_totaltoppersen();
    });           

    $("#btn-lockso").click(function(){
        $("#popup-lockso").modal();
    });

    $("#btn-lockso-yes").click(function(){                                                    
          $.ajax({
              url: "<?php echo base_url('sales_order/sales_order_lockso'); ?>",
              type: 'POST', 
              data:{trso_no: $("#trso_no").val(), trso_sisadp: $("#trso_sisadp").val(), trso_cekint: $("#trso_cekint").val(), key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",            
              success: function(result){                                        
                  if (result.response == "gagal") {
                      var errmsg="";
                      $.each(result.error_message, function (index, value) {
                          errmsg += value;                            
                      });
                      falertwarning(errmsg);
                      $("#popup-lockso").modal("hide");
                  }else{                        
                      window.location.href = "<?php echo base_url('sales_order/sales_order_view'); ?>" + "/" + result.trso_no;
                  }
              }      
           });                           
    });
    
    $("#btn-cancellockso").click(function(){
        $("#popup-cancellockso").modal();
    });

    $("#btn-cancellockso-yes").click(function(){                                                    
          $.ajax({
              url: "<?php echo base_url('sales_order/sales_order_cancellockso'); ?>",
              type: 'POST', 
              data:{trso_no: $("#trso_no").val(), trso_stcopy: $("#trso_stcopy").val(), trso_cekint: $("#trso_cekint").val(), trso_total: $("[name='trso_total']").val(), key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",            
              success: function(result){                                        
                  if (result.response == "gagal") {
                      var errmsg="";
                      $.each(result.error_message, function (index, value) {
                          errmsg += value;                            
                      });
                      falertwarning(errmsg);
                      $("#popup-cancellockso").modal("hide");
                  }else{                        
                      window.location.href = "<?php echo base_url('sales_order/sales_order_view'); ?>" + "/" + result.trso_no;
                  }
              }      
           });                           
    });
    
    $("#msus_nm, #msus_pswd").focus(function(){
        $("#otorasi_langsung").prop("checked", true);
    });

    $("#user_otorisasi, #kode_otorisasi").focus(function(){
        $("#otorasi_using_key").prop("checked", true);
    });

    $("#btn-edit-trso_catatan").click(function(){
        $("#p_trso_catatan").val($("#trso_catatan").val());
    });

    $("#btn-save-trso_catatan").click(function(){
        $.ajax({
              url: "<?php echo base_url('sales_order/sales_order_edit_catatan'); ?>",
              type: 'POST', 
              data:{trso_no: $("#trso_no").val(), trso_catatan: $("#p_trso_catatan").val(), trso_cekint: $("#trso_cekint").val(), key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",            
              success: function(result){                                        
                  if (result.response == "gagal") {
                      var errmsg="";
                      $.each(result.error_message, function (index, value) {
                          errmsg += value;                            
                      });
                      falertwarning(errmsg);
                      $("#popup-edit-trso_catatan").modal("hide");
                  }else{                        
                      window.location.href = "<?php echo base_url('sales_order/sales_order_view'); ?>" + "/" + result.trso_no;
                  }
              }      
           });    
    });        
                          
</script>
<!-- =====================================================End Event=========================================== -->



<!-- =====================================================Function=========================================== -->
<script type="text/javascript">             
      
      function fmax_seqpaket(){
          var vmax = 0; 
          var n = 0;

            $('.seqpaket').each(function(){
                n = parseInt($(this).val());
                if(n > vmax){
                  vmax = n;
                }
            });
           return vmax += 1;
      }

      function fmax_seq_dt(){
        var vmax = 0; 
        var n = 0;

          $('.max_seq_dt').each(function(){
              n = parseInt($(this).val());
              if(n > vmax){
                vmax = n;
              }
          });
         return vmax += 1;
        }

        function fmax_seq_top(){
        var vmax = 0; 
        var n = 0;

          $('.max_seq_top').each(function(){
              n = parseInt($(this).val());
              if(n > vmax){
                vmax = n;
              }
          });
         return vmax += 1;
        }

      function fset_datepicker(){
        $(".datepicker").datetimepicker({
            format:'Y-m-d',
            timepicker:false
        });   
      }
                       
     function falertsuccess() {      
          $.notify({
          // options
            message: "Data successfully saved."
          },{
            // settings
            type: 'success',    
            placement: {
                align: 'center'
              },
            animate:{
              enter: 'animated bounceInDown',
              exit: 'animated bounceOutUp'
            }
          });
      }      

      function falertwarning(value) {     
            $.notify({
            // options
              message: value
            },{
              // settings
              type: 'warning',              
              placement: {
                  align: 'center'
                },
              animate:{
                enter: 'animated bounceInDown',
                exit: 'animated bounceOutUp'
              }
            });
      }

      // function fcount_persentop(curr_row, value){          
      //     var tpso_persen = parseFloat(ftodouble(value));
      //     var dtso_total = parseFloat(ftodouble($("#dtso_total").val()));        
      //     var tpso_value = (tpso_persen / 100) * dtso_total;
      //     curr_row.find(".tpso_value").val(tpso_value);
      //     curr_row.find(".tpso_value").autoNumeric("update");
      // }

      // function fcount_valuetop(curr_row, value){
      //     var tpso_value = parseFloat(ftodouble(value));
      //     var dtso_total = parseFloat(ftodouble($("#dtso_total").val()));        
      //     var tpso_persen = (tpso_value / dtso_total) * 100;
      //     curr_row.find(".tpso_persen").val(tpso_persen);
      //     curr_row.find(".tpso_persen").autoNumeric("update");
      // }

      function fcount_valuetop(curr_row, value){          
          var dtso_total = $("#dtso_total").val();        

          if(dtso_total == undefined){
              dtso_total = 0;
          }else{
              dtso_total = parseFloat(ftodouble(dtso_total));
          }

          if(dtso_total != 0){                
            var tpso_persen = parseFloat(ftodouble(value));
            var tpso_value = (tpso_persen / 100) * dtso_total;
            curr_row.find(".tpso_value").val(tpso_value);
            curr_row.find(".tpso_value").autoNumeric("update");
          }else{
            curr_row.find(".tpso_persen").val(0);
          }
      }

      function fcount_persentop(curr_row, value){
          var tpso_value = parseFloat(ftodouble(value));
          var dtso_total = $("#dtso_total").val();        
          var tpso_persen;

          if(dtso_total == undefined || dtso_total == 0){
              tpso_persen = 0;
          }else{
              dtso_total = parseFloat(ftodouble(dtso_total));
              tpso_persen = ((tpso_value / dtso_total) * 100).toFixed(4);
          }

          curr_row.find(".tpso_persen").val(tpso_persen);
          curr_row.find(".tpso_persen").autoNumeric("update");
      }

      function fcount_totaltop(){
          var total_value = 0;

          $(".tpso_value").each(function(){
              if($(this).val() != ""){
                total_value += parseFloat(ftodouble($(this).val()));
              }
          });

          $("#top_total").val(total_value);
      }

      function fcount_totaltoppersen(){
          var persen = 0;

          $(".tpso_persen").each(function(){
              if($(this).val() != ""){
                persen += parseFloat(ftodouble($(this).val()));
              }
          });

          $("#top_persen_total").val(persen);
      }

      function fcount_top(){       
          $(".tpso_value").each(function(){
              var curr_row = $(this).parents("tr");        
              if($(this).val() != ""){
                  var val = parseFloat(ftodouble($(this).val()));
                  if(val != 0){
                    // fcount_valuetop(curr_row, curr_row.find(".tpso_value").val());
                    fcount_persentop(curr_row, curr_row.find(".tpso_value").val());
                  }
              }    
          });
      }

       function fcount_total(){
          var dtso_total = 0;        
          var dtso_bftaxtotal = 0;
          var dtso_taxtotal = 0;
          var dtso_netttotal = 0;

          $(".dtso_bftax").each(function(){
              if($(this).val() != ""){
                dtso_bftaxtotal += parseFloat(ftodouble($(this).val()));              
              }              
          });

          $(".dtso_tax").each(function(){
              if($(this).val() != ""){
                dtso_taxtotal += parseFloat(ftodouble($(this).val()));              
              }              
          });

          $(".dtso_nett").each(function(){
              if($(this).val() != ""){
                dtso_netttotal += parseFloat(ftodouble($(this).val()));              
              }              
          });

          $(".dtso_total").each(function(){
              if($(this).val() != ""){
                dtso_total += parseFloat(ftodouble($(this).val()));              
              }              
          });

          $("#dtso_bftaxtotal").autoNumeric('set', dtso_bftaxtotal); 
          $("#dtso_taxtotal").autoNumeric('set', dtso_taxtotal); 
          $("#dtso_netttotal").autoNumeric('set', dtso_netttotal); 
          $("#dtso_total").autoNumeric('set', dtso_total); 
      }

      function fcountprice_from_discmax(curr_row_left, mscs_jenis){            
          var dtso_mspd_no = curr_row_left.find(".dtso_mspd_no").val();
          var dtso_mdpp_no = curr_row_left.find(".dtso_mdpp_no").val();
          var dtso_statuspaket = curr_row_left.find(".dtso_statuspaket").val();

          if(dtso_mspd_no != ""){
              if((dtso_mdpp_no == "") || (dtso_mdpp_no != "" && dtso_statuspaket == 'P')){
                  var dtso_pricelist = parseFloat(ftodouble(curr_row_left.find(".dtso_pricelist").val()));          
                  var mskt_discnonagen1 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen1").attr("mskt_discnonagen1")));
                  var mskt_discnonagen2 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen2").attr("mskt_discnonagen2")));
                  var mskt_discnonagen3 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen3").attr("mskt_discnonagen3")));          
          
                  var mskt_discagen1 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen1").attr("mskt_discagen1")));
                  var mskt_discagen2 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen2").attr("mskt_discagen2")));
                  var mskt_discagen3 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen3").attr("mskt_discagen3")));
                                  
                  if(mscs_jenis == "R"){
                      var minprice = ((100-mskt_discnonagen1) / 100) * dtso_pricelist;
                          minprice = ((100-mskt_discnonagen2) / 100) * minprice;
                          minprice = ((100-mskt_discnonagen3) / 100) * minprice;
                      curr_row_left.find(".dtso_minprice").autoNumeric('init', {aPad:false, mDec:4});
                      curr_row_left.find(".dtso_minprice").autoNumeric('set', minprice);
                  }

                  if(mscs_jenis == "A"){
                      var minprice = ((100-mskt_discagen1) / 100) * dtso_pricelist;
                          minprice = ((100-mskt_discagen2) / 100) * minprice;
                          minprice = ((100-mskt_discagen3) / 100) * minprice;
                      curr_row_left.find(".dtso_minprice").autoNumeric('init', {aPad:false, mDec:4});
                      curr_row_left.find(".dtso_minprice").autoNumeric('set', minprice);
                  }
              }
          }
          
      } 

      function fcountprice_from_qty(curr_row_left, curr_row_right){          
          var dtso_nett = parseFloat(ftodouble(curr_row_left.find(".dtso_nett").val()));
          var dtso_qty = parseFloat(ftodouble(curr_row_left.find(".dtso_qty").val()));  

          var total = dtso_nett * dtso_qty;
              total = total.toFixed(4);

          // $(".auto-numeric").autoNumeric('init');
          $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});                  
          curr_row_right.find(".dtso_total").autoNumeric('set', total);        
      }                    

      function fcountprice_from_discount(curr_row_left, curr_row_right){  
          var tgl_so = $('#trso_tgl').val();
          var tarifPPN = fgettarifppn(tgl_so);

          var mskt_statusinv = curr_row_left.find(".mskt_statusinv").val();
          var dtso_pricelist = parseFloat(ftodouble(curr_row_left.find(".dtso_pricelist").val()));
          var dtso_discpersen1 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen1").val()));          
          var dtso_discpersen2 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen2").val()));
          var dtso_discpersen3 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen3").val()));
          var dtso_discrp = parseFloat(ftodouble(curr_row_left.find(".dtso_discrp").val()));          
          var dtso_qty = parseFloat(ftodouble(curr_row_left.find(".dtso_qty").val()));   
                          
          var bftax = ((100-dtso_discpersen1) / 100) * dtso_pricelist;
              bftax = ((100-dtso_discpersen2) / 100) * bftax;                                        
              bftax = ((100-dtso_discpersen3) / 100) * bftax;                
              bftax = bftax - dtso_discrp;

          var tax = +(parseFloat((tarifPPN / 100) * bftax).toPrecision(12));
              tax = ("<?php echo $tipe_trans; ?>" == 'C') ? 0 : tax.toFixed(4);
          var nett = bftax + parseFloat(tax);
          var total = nett * dtso_qty;
              total = total.toFixed(4)
                             
           // $(".auto-numeric").autoNumeric('init');
           $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
          curr_row_left.find(".dtso_bftax").autoNumeric('set', bftax);
          curr_row_left.find(".dtso_tax").autoNumeric('set', tax);
          curr_row_left.find(".dtso_nett").autoNumeric('set', nett);
          curr_row_right.find(".dtso_total").autoNumeric('set', total);
      }

      function fcountprice_from_bftax(curr_row_left, curr_row_right){
          var tgl_so = $('#trso_tgl').val();
          var tarifPPN = fgettarifppn(tgl_so);

          var mskt_statusinv = curr_row_left.find(".mskt_statusinv").val();
          var dtso_pricelist = parseFloat(ftodouble(curr_row_left.find(".dtso_pricelist").val()));
          var dtso_discpersen1 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen1").val()));          
          var dtso_discpersen2 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen2").val()));
          var dtso_discpersen3 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen3").val()));               
          var dtso_discrp = parseFloat(ftodouble(curr_row_left.find(".dtso_discrp").val()));
          var dtso_bftax = parseFloat(ftodouble(curr_row_left.find(".dtso_bftax").val()));
          var dtso_nett = parseFloat(ftodouble(curr_row_left.find(".dtso_nett").val()));
          var dtso_qty = parseFloat(ftodouble(curr_row_left.find(".dtso_qty").val()));  

          var bfbftax = ((100-dtso_discpersen1) / 100) * dtso_pricelist;          
              bfbftax = ((100-dtso_discpersen2) / 100) * bfbftax;                    
              bfbftax = ((100-dtso_discpersen3) / 100) * bfbftax;
          
          var bftax = dtso_bftax;
          var tax = +(parseFloat((tarifPPN / 100) * bftax).toPrecision(12));
              tax = ("<?php echo $tipe_trans; ?>" == 'C') ? 0 : tax.toFixed(4);
          var nett = parseFloat(bftax) + parseFloat(tax);          
          
          //var discrp = (dtso_pricelist - bfbftax)  - tax;
          var discrp = bfbftax - bftax;
          var total = nett * dtso_qty;
              total = total.toFixed(4);

           // $(".auto-numeric").autoNumeric('init');
           $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
          curr_row_left.find(".dtso_tax").autoNumeric('set', tax);        
          curr_row_left.find(".dtso_nett").autoNumeric('set', nett);
          curr_row_left.find(".dtso_discrp").autoNumeric('set', discrp);        
          curr_row_right.find(".dtso_total").autoNumeric('set', total);        
      }

      function fcountprice_from_nett(curr_row_left, curr_row_right){
          var tgl_so = $('#trso_tgl').val();
          var tarifPPN = fgettarifppn(tgl_so);

          var mskt_statusinv = curr_row_left.find(".mskt_statusinv").val();
          var dtso_pricelist = parseFloat(ftodouble(curr_row_left.find(".dtso_pricelist").val()));
          var dtso_discpersen1 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen1").val()));          
          var dtso_discpersen2 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen2").val()));
          var dtso_discpersen3 = parseFloat(ftodouble(curr_row_left.find(".dtso_discpersen3").val()));               
          var dtso_discrp = parseFloat(ftodouble(curr_row_left.find(".dtso_discrp").val()));
          var dtso_nett = parseFloat(ftodouble(curr_row_left.find(".dtso_nett").val()));
          var dtso_qty = parseFloat(ftodouble(curr_row_left.find(".dtso_qty").val()));
                    
          var bfbftax = ((100-dtso_discpersen1) / 100) * dtso_pricelist;        
              bfbftax = ((100-dtso_discpersen2) / 100) * bfbftax;                                                        
              bfbftax = ((100-dtso_discpersen3) / 100) * bfbftax;                                    

          var bftax = ("<?php echo $tipe_trans; ?>" == 'C') ? dtso_nett : (dtso_nett * 100 / (100 + tarifPPN)).toFixed(4);
          var tax = dtso_nett - bftax;
          var discrp = bfbftax - bftax;      
          var total = dtso_nett * dtso_qty;
              total = total.toFixed(4);

          // $(".auto-numeric").autoNumeric('init');
          $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
          curr_row_left.find(".dtso_bftax").autoNumeric('set', bftax);
          curr_row_left.find(".dtso_tax").autoNumeric('set', tax);        
          curr_row_left.find(".dtso_discrp").autoNumeric('set', discrp);        
          curr_row_right.find(".dtso_total").autoNumeric('set', total);        
      }

      function add_inputblank(){

            var last_id = $("#salesorder-datadetail-tbody").find("#dtso_row_total").prev().find(".dtso_mspd_no").val();
            if(last_id == ""){              
                return false;
            }            

            var row_input_blank_left = '<tr>'                                        
                                        +'<td class="produk_id"><input type="text" placeholder="search ID" name="dtso[dtso_mspd_no][]" class="form-control srstyle-ta-center dtso_mspd_no dtso_mspd_no_avl" value=""/></td>'
                                        +'<td class="fixededit"><input type="text" name="temp_dtso[mspd_nm][]" placeholder="search Product" class="form-control dtso_mspd_nm" value=""/></td>'
                                        +'<td><input type="text" readonly class="form-control mspd_qtyavl srstyle-ta-right auto-numeric" value=""/></td>'
                                        +'<td><input type="text" name="dtso[dtso_qty][]" class="form-control dtso_qty srstyle-bgcolorqty srstyle-ta-right auto-numeric" value=""/></td>'                                      
                                        +'<td><input type="text" readonly class="form-control srstyle-ta-right dtso_qtykirim auto-numeric" value=""/></td>'
                                        +'<td><input type="text" name="dtso[dtso_curr][]" class="form-control dtso_curr srstyle-ta-center" value="" readonly/></td>'
                                        +'<td><input type="text" name="dtso[dtso_pricelistcurr][]" class="form-control dtso_pricelistcurr srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                        +'<td><input type="text" name="dtso[dtso_pricelist][]" class="form-control dtso_pricelist srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                        +'<td><input type="text" name="dtso[dtso_discpersen1][]" class="form-control dtso_discpersen1 srstyle-ta-right auto-numeric" value=""/></td>'
                                        +'<td><input type="text" name="dtso[dtso_discpersen2][]" class="form-control dtso_discpersen2 srstyle-ta-right auto-numeric" value=""/></td>'
                                        +'<td><input type="text" name="dtso[dtso_discpersen3][]" class="form-control dtso_discpersen3 srstyle-ta-right auto-numeric" value=""/></td>'
                                        +'<td><input type="text" name="dtso[dtso_discrp][]" class="form-control dtso_discrp srstyle-ta-right auto-numeric" value=""/></td>'                                                                                
                                        +'<td><input type="text" name="dtso[dtso_bftax][]" class="form-control dtso_bftax srstyle-ta-right auto-numeric" value="" /></td>'
                                        +'<td><input type="text" name="dtso[dtso_tax][]" class="form-control dtso_tax srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                        +'<td><input type="text" name="dtso[dtso_nett][]" class="form-control dtso_nett srstyle-ta-right auto-numeric" value=""/></td>'                                        
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_seq][]" class="form-control dtso_seq max_seq_dt" value=""/></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_mdpp_no][]" class="form-control dtso_mdpp_no" value=""/></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_seqpaket][]" readonly class="form-control srstyle-ta-right seqpaket dtso_seqpaket" value=""/></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_statuspaket][]" readonly class="form-control srstyle-ta-right dtso_statuspaket" value=""/></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_minprice][]" class="form-control dtso_minprice srstyle-ta-right auto-numeric" value="" /></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[dtso_msus_no][]" class="form-control dtso_msus_no srstyle-ta-center" value="" /></td>'
                                        +'<td style="display:none;"><input type="text" class="form-control mskt_statusinv srstyle-ta-center" value=""/></td>'
                                        +'<td style="display:none;"><input type="text" name="dtso[mspd_reqserialno][]" class="form-control mspd_reqserialno srstyle-ta-center" value=""/></td>'
                                    +'</tr>';
            var row_input_blank_right = '<tr>'
                                          +'<td><input style="width:150px;" type="text" class="form-control dtso_total srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                          +'<td style="text-align:center;"><button type="button" class="btn-view-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail" style="visibility:hidden;"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="link">link</i></button></td>'  
                                          +'<td style="text-align:center;" class="btn-delete-produk"><button type="button" class="btn-delete-produk srstyle-cursor srstyle-actdetailicon srstyle-actiondetail" style="visibility:hidden;"><i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="remove">remove_circle_outline</i></button></td>' 
                                        +'</tr>'
            $("#salesorder-datadetail-tbody").find("#dtso_row_total").before(row_input_blank_left);                      
            $("#salesorder-action-tbody").find("#dtso_row_total").before(row_input_blank_right);
          
            fautocomplete();
            // $(".auto-numeric").autoNumeric("init");
            $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
            $(".auto-numeric").autoNumeric("update");
      }

      function add_grandtotal(){

      var row_grandtotal_left = '<tr id="dtso_row_total" class="srstyle-rowcountdetail">'
                                      +'<td colspan="11" class="srstyle-detailcount-label">Total</td>'                                      
                                      +'<td><input type="text" id="dtso_bftaxtotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                      +'<td><input type="text" id="dtso_taxtotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                      +'<td><input type="text" id="dtso_netttotal" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                +'</tr>';
         
          var row_grandtotal_right = '<tr id="dtso_row_total">'                                      
                                      +'<td><input style="width: 150px;" type="text" name="trso_total" id="dtso_total" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>'
                                      +'<td></td>' 
                                    +'</tr>';

           $("#salesorder-datadetail-tbody").append(row_grandtotal_left);
           $("#salesorder-action-tbody").append(row_grandtotal_right);
      }

      function fautocomplete(){
           $('.dtso_mspd_no').devbridgeAutocomplete({
                  params:{input_name:"mspd_no",key:$("#key").val(), hash_key:$("#hash_key").val(), mspd_paket:'N', mspd_fin:"<?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>"},
                  type:"POST",
                  serviceUrl: "<?php echo base_url('produk/produk_autocomplete/'); ?>", 
                  onSelect: function (suggestion) {                    
                      if(is_trigger_focus || is_trigger_mouse){                                                                 
                            $("div.srstyle-col-content").scrollLeft("0px");  
                            var mscs_jenis = $("#mscs_jenis").val();
                            var curr_row_left = $(this).parents("tr");                          
                            var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
                            var idx = curr_row_left.index();
                            arrac_mspd_no[idx] = suggestion.mspd_no;
                            var mspd_curr = suggestion.mspd_curr;
                            var kurs = parseFloat(ftodouble($("#trso_kurs").val()));
                            var dtso_pricelist = (mspd_curr == 'RP') ? suggestion.mspd_pricelist : suggestion.mspd_pricelist * kurs;          
                            
                            curr_row_left.find(".dtso_mspd_no").val(suggestion.mspd_no);
                            curr_row_left.find(".dtso_mspd_nm").val(suggestion.mspd_nm);
                            curr_row_left.find(".dtso_curr").val(suggestion.mspd_curr);
                            curr_row_left.find(".dtso_pricelistcurr").val(suggestion.mspd_pricelist);
                            curr_row_left.find(".dtso_pricelist").val(dtso_pricelist);

                            curr_row_left.find(".dtso_discpersen1").attr("mskt_discnonagen1", suggestion.mskt_discnonagen1);
                            curr_row_left.find(".dtso_discpersen2").attr("mskt_discnonagen2", suggestion.mskt_discnonagen2);
                            curr_row_left.find(".dtso_discpersen3").attr("mskt_discnonagen3", suggestion.mskt_discnonagen3);
                        
                            curr_row_left.find(".dtso_discpersen1").attr("mskt_discagen1", suggestion.mskt_discagen1);
                            curr_row_left.find(".dtso_discpersen2").attr("mskt_discagen2", suggestion.mskt_discagen2);
                            curr_row_left.find(".dtso_discpersen3").attr("mskt_discagen3", suggestion.mskt_discagen3);
                            
                            curr_row_left.find(".dtso_discpersen1").val(0);
                            curr_row_left.find(".dtso_discpersen2").val(0);
                            curr_row_left.find(".dtso_discpersen3").val(0);

                            curr_row_left.find(".dtso_discrp").val(0);                            
                            curr_row_left.find(".dtso_bftax").val(0);
                            curr_row_left.find(".dtso_tax").val(0);
                            // curr_row_left.find(".dtso_nett").val(dtso_pricelist + dtso_tax);
                            curr_row_left.find(".dtso_nett").val(dtso_pricelist);
                            curr_row_left.find(".mspd_qtyavl").addClass(suggestion.mspd_no + "avl");
                            curr_row_left.find(".dtso_qty").val(1);
                            curr_row_left.find(".dtso_qtykirim").val(0);

                            //if(suggestion.mspd_reqserialno == 'Y' || suggestion.mskt_statusinv == 'N'){
                            if(suggestion.mspd_reqserialno == 'Y'){
                              curr_row_left.find(".dtso_qty").attr("readonly", true);
                            }else{
                              curr_row_left.find(".dtso_qty").attr("readonly", false);
                            }
                            
                            curr_row_left.find(".mskt_statusinv").val(suggestion.mskt_statusinv);
                            curr_row_left.find(".mspd_reqserialno").val(suggestion.mspd_reqserialno);
                            if(curr_row_left.find(".dtso_seqpaket").val() == ""){
                              curr_row_left.find(".dtso_seqpaket").val(fmax_seqpaket());
                            }
                            if(curr_row_left.find(".dtso_seq").val() == ""){
                              curr_row_left.find(".dtso_seq").val(fmax_seq_dt());
                            }
                            curr_row_left.find(".dtso_statuspaket").val("N");
                            curr_row_right.find(".btn-delete-produk").css("visibility","visible"); 
                            curr_row_right.find(".btn-view-produk").css("visibility","visible"); 

                            fcountprice_from_discmax(curr_row_left, mscs_jenis);
                            // fcountprice_from_discount(curr_row_left, curr_row_right);
                            fcountprice_from_nett(curr_row_left, curr_row_right);
                            add_inputblank();
                            fcount_total();   
                            fset_info_avaliablestock();                    
                            fcount_top();
                            fcount_totaltop();                            
                            fcount_totaltoppersen();
                            // $(".auto-numeric").autoNumeric("init");
                            $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
                            $(".auto-numeric").autoNumeric("update");
                      }
                      is_trigger_focus = true;                      
                      is_trigger_mouse = false;                     
                  },                  
                  showNoSuggestionNotice:true            
              });
              
              $('.dtso_mspd_nm').devbridgeAutocomplete({
                  params:{input_name:"mspd_nm",key:$("#key").val(), hash_key:$("#hash_key").val(), mspd_paket:'N', mspd_fin:"<?php echo ($tipe_trans == 'F') ? 'F' : 'C'; ?>"},
                  type:"POST",
                  serviceUrl: "<?php echo base_url('produk/produk_autocomplete/'); ?>",                        
                  onSelect: function (suggestion) {
                      if(is_trigger_focus || is_trigger_mouse){                            
                          $("div.srstyle-col-content").scrollLeft("0px");  
                          var mscs_jenis = $("#mscs_jenis").val();
                          var curr_row_left = $(this).parents("tr");
                          var curr_row_right = $("#salesorder-action-tbody tr").eq(curr_row_left.index());
                          var idx = curr_row_left.index();
                          arrac_mspd_nm[idx] = suggestion.mspd_nm;
                          var mspd_curr = suggestion.mspd_curr;
                          var kurs = parseFloat(ftodouble($("#trso_kurs").val()));          
                          var dtso_pricelist = (mspd_curr == 'RP') ? suggestion.mspd_pricelist : suggestion.mspd_pricelist * kurs;          
                          
                          curr_row_left.find(".dtso_mspd_no").val(suggestion.mspd_no);
                          curr_row_left.find(".dtso_mspd_nm").val(suggestion.mspd_nm);
                          curr_row_left.find(".dtso_curr").val(suggestion.mspd_curr);
                          curr_row_left.find(".dtso_pricelistcurr").val(suggestion.mspd_pricelist);
                          curr_row_left.find(".dtso_pricelist").val(dtso_pricelist);

                          curr_row_left.find(".dtso_discpersen1").attr("mskt_discnonagen1", suggestion.mskt_discnonagen1);
                          curr_row_left.find(".dtso_discpersen2").attr("mskt_discnonagen2", suggestion.mskt_discnonagen2);
                          curr_row_left.find(".dtso_discpersen3").attr("mskt_discnonagen3", suggestion.mskt_discnonagen3);
                      
                          curr_row_left.find(".dtso_discpersen1").attr("mskt_discagen1", suggestion.mskt_discagen1);
                          curr_row_left.find(".dtso_discpersen2").attr("mskt_discagen2", suggestion.mskt_discagen2);
                          curr_row_left.find(".dtso_discpersen3").attr("mskt_discagen3", suggestion.mskt_discagen3);
                          
                          curr_row_left.find(".dtso_discpersen1").val(0);
                          curr_row_left.find(".dtso_discpersen2").val(0);
                          curr_row_left.find(".dtso_discpersen3").val(0);
                          
                          curr_row_left.find(".dtso_discrp").val(0);
                          curr_row_left.find(".dtso_bftax").val(0);
                          curr_row_left.find(".dtso_tax").val(0);
                          // curr_row_left.find(".dtso_nett").val(dtso_pricelist + dtso_tax);
                          curr_row_left.find(".dtso_nett").val(dtso_pricelist);
                          curr_row_left.find(".mspd_qtyavl").addClass(suggestion.mspd_no + "avl");
                          curr_row_left.find(".dtso_qty").val(1);
                          curr_row_left.find(".dtso_qtykirim").val(0);

                          // if(suggestion.mspd_reqserialno == 'Y' || suggestion.mskt_statusinv == 'N'){
                          if(suggestion.mspd_reqserialno == 'Y'){
                            curr_row_left.find(".dtso_qty").attr("readonly", true);
                          }else{
                            curr_row_left.find(".dtso_qty").attr("readonly", false);
                          }
                                                    
                          curr_row_left.find(".mskt_statusinv").val(suggestion.mskt_statusinv);
                          curr_row_left.find(".mspd_reqserialno").val(suggestion.mspd_reqserialno);
                          if(curr_row_left.find(".dtso_seqpaket").val() == ""){
                            curr_row_left.find(".dtso_seqpaket").val(fmax_seqpaket());
                          }
                          if(curr_row_left.find(".dtso_seq").val() == ""){
                            curr_row_left.find(".dtso_seq").val(fmax_seq_dt());
                          }
                          curr_row_left.find(".dtso_statuspaket").val("N");
                          curr_row_right.find(".btn-delete-produk").css("visibility","visible");
                          curr_row_right.find(".btn-view-produk").css("visibility","visible");

                          fcountprice_from_discmax(curr_row_left, mscs_jenis);
                          // fcountprice_from_discount(curr_row_left, curr_row_right);
                          fcountprice_from_nett(curr_row_left, curr_row_right);
                          add_inputblank();
                          fcount_total();   
                          fset_info_avaliablestock();                     
                          fcount_top();
                          fcount_totaltop();         
                          fcount_totaltoppersen();                 
                          // $(".auto-numeric").autoNumeric("init");
                          $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
                          $(".auto-numeric").autoNumeric("update");
                      }
                      is_trigger_focus = true;                      
                      is_trigger_mouse = false;
                  },                  
                  showNoSuggestionNotice:true            
              });
        }

        function fset_info_avaliablestock(){
            var varr_mspd_no = $('.dtso_mspd_no_avl').map(function() {
                if($(this).val() != ""){
                  return $(this).val();
                }                          
            }).toArray();                  

            if(varr_mspd_no.length > 0){                                                                          
                $.ajax({
                    method:"POST",
                    url:"<?php echo base_url('produk/produk_avaliablestock'); ?>",
                    data:{key:$("#key").val(), hash_key:$("#hash_key").val(), arr_mspd_no:varr_mspd_no},
                    dataType:"json",
                    success:function(r){                                                           
                        for (var i = 0; i < r.length; i++) {                          
                            if(r[i]['mspd_paket'] == "N"){
                              var avl_stok = (r[i]['mskt_statusinv'] == "Y") ? r[i]['mspd_qtyavl'] : 0;
                              $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', avl_stok);
                            }else{
                              $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', 0);
                            }                           
                        }                                               
                    }
                });  
            }                  
        }
       
</script>
<!-- =====================================================End Function=========================================== -->

