<?php   
  function fset_input_customer($action, $header, $default){
      if($action == 'new'){
        return $default;
      }else if($action == 'new_import'){
        return $header['trsd_mscs_no']. ' - '. $header['mscs_nm'];
      }else{
        return $header['trsr_mscs_no']. ' - '. $header['mscs_nm'];
      }
  }  
?>

<nav class="navbar">
    <div class="container-fluid">
        <div class="pull-right navbar-right">

            <?php 
            if(fcek_hak_akses('.CC0.')) { ?>
                <a class="btn-view-list" id="btn-view-list" href="<?php echo base_url('sales_retur'); ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="View List">view_list</i>
                </a><?php
            } ?>

            <?php 
            if(fcek_hak_akses('.CC1.')) { ?>
                <a class="btn-new" id="btn-new" href="<?php echo base_url('sales_retur/sales_retur_new'); ?>">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="New">insert_drive_file</i>
                </a><?php
            } ?>

            <?php
            if(fcek_hak_akses('.CC2.')) {
                if($header['trsr_tglterima'] == '0000-00-00'){ ?> 
                    <a class="btn-edit" id="btn-edit" href="javascript:void(0);">
                        <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Edit">create</i>
                    </a><?php
                } 
            } ?>    

            <?php
            if(fcek_hak_akses('.CC6.')) { ?>
                 <a class="btn-print" id="btn-print" href="javascript:void(0);" title="WARNING!" data-toggle="popover"  data-trigger="focus" data-placement="left" data-content="For authorized users only">
                  <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Print">print</i>
                </a><?php
            } ?>
            
            <?php
            if(fcek_hak_akses('.CC5.')) {
                if($header['trsr_tglterima'] == '0000-00-00'){ ?>
                <a class="btn-void" id="btn-void" href="javascript:void(0);">
                    <i class="material-icons tooltip-general" data-toggle="tooltip" data-placement="bottom" title="Void">delete_forever</i>                    
                </a><?php
                } 
            } ?>                                                            

            <?php
            if(fcek_hak_akses('.CC1.')) { ?>
                <a class="btn-import-sd srstyle-btnnavbar" id="btn-import-sd"  href="javascript:void(0);">
                    <button type="button" class="btn">Import Sales Delivery</button>
                </a><?php
            } ?>

            <?php
            if(fcek_hak_akses('.CC7.')) {
                if($header['trsr_tglterima'] == '0000-00-00' && $header['trsr_void'] == 0){ ?> 
                    <a class="btn-conf-receiving-goods srstyle-btnnavbar" id="btn-conf-receiving-goods"  href="javascript:void(0);">
                        <button type="button" class="btn">Confirm Receiving Goods</button>
                    </a><?php
                } 
            } ?>

            <?php
            if(fcek_hak_akses('.CC8.')) {
                if($header['trsr_tglterima'] != '0000-00-00' && $header['is_srhaspaid'] == 0){ ?>
                    <a class="btn-cancel-receiving-goods srstyle-btnnavbar" id="btn-cancel-receiving-goods" href="javascript:void(0);">
                        <button type="button" class="btn">Cancel Receiving Goods</button>      
                    </a><?php                
                } 
            } ?>

        </div>
        <?php $this->load->view('v_navbar_topleft') ?>
    </div>
</nav>

<style type="text/css">
.produknamecol {
  min-width: 400px;
  padding-top: 0;
}
.fixedname {
     position:absolute;
     margin :  0px;
     left: 0%;
     padding-top: 0;
}
.fixed_table {
  min-width: 150px;
  
}
.display_id{
  display: none;
}
</style>


<div class="row clearfix">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">                      
        <div class="card srstyle-card">
            <div id="data-form-container">                

                <!-- ============================================ Sales Return Form ====================================== -->
                <div class="srstyle-title">Sales Return</div>
                        
                <form id="sales_retur-form" autocomplete="off" method="POST" action="<?php echo base_url('sales_retur/sales_retur_edit_simpan'); ?>">
                    <input type="hidden" name="key" id="key" value="<?php echo $key ?>" >
                    <input type="hidden" name="hash_key" id="hash_key" value="<?php echo $hash_key ?>" >
                    <input type="hidden" name="trsd_no" id="trsd_no" value="<?php echo ($action == 'new') ? '' : $header['trsd_no']; ?>" >
                    <input type="hidden" name="trsr_cekint" id="trsr_cekint" value="<?php echo ($action == 'view') ? $header['trsr_cekint'] : ''; ?>" >
                    <input type="hidden" name="trsd_cekint" id="trsd_cekint" value="<?php echo ($action == 'new') ? '' : $header['trsd_cekint']; ?>" >
                    <input type="hidden" name="mscs_jenis" class="form-control auto-numeric" id="mscs_jenis" value="<?php echo $header['mscs_jenis']; ?>">
                    <input type="hidden" name="trju_no" class="form-control auto-numeric" id="trju_no" value="<?php echo ($action == 'view') ? $jurnal_h['trju_no'] : ''; ?>">
                    <input type="hidden" name="trso_fin" id="trso_fin" value="<?php echo ($action == 'view') ? $header['trso_fin'] : ''; ?>" >
                    
                    <?php 
                    if($action == 'view'){                     
                            if($header['trsr_void'] == 1) {?>
                                <div class="alert-danger srstyle-boxvoid">
                                    <h2>VOID</h2>
                                </div>
                  <?php     }                         
                    } ?>                          

                    <?php $trsr_mscb_no = ($action == 'view') ? $header['trsr_mscb_no'] : $this->session->userdata('user_aktif')['msus_mscb_no']; ?>      

                    <!-- SRS Toogle -->
                    <div class="col-ms-12 col-md-12 col-xs-12 SRSHeaderFormTop"> 

                        <!-- SRS Toogle -->
                        <div class="lokasi_cb_area SRSLokasiCbArea">
                              <label class="SRSToogleContainer">
                                  <input type="radio" name="trsr_mscb_no" id="trsr_mscb_no" value="<?php echo $trsr_mscb_no; ?>" checked disabled>
                                  <div class="SRSToogleArea"> <?php echo $trsr_mscb_no; ?> </div>
                              </label>
                        </div>

                        <div class="SRSBox">                            
                             <?php echo (($action == 'view') ? $header['trsr_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']); ?>
                        </div>

                        <div class="SRSBox">
                          <input type="text" class="srstyle-date-trans" name="trsr_tgl" id="trsr_tgl" value="<?php echo (($action == 'view') ? $header['trsr_tgl'] : date('Y-m-d H:i:s')); ?>" readonly>
                        </div>

                        <?php
                        if($action == 'view'){ 
                            if($header['trsr_tglterima'] != '0000-00-00'){
                              $conf_status = 'RG-CONFIRMED';
                              $conf_status_bg = '#20ff80';
                            }else{
                              $conf_status = 'RG-NOT YET CONFIRMED';
                              $conf_status_bg = '#FF6347';
                            } ?>                            

                            <div class="SRSBox" style="background-color:<?php echo $conf_status_bg; ?>"> 
                                 <?php echo $conf_status; ?>
                            </div><?php

                            if($header['trsr_jenis'] == 'V'){
                                if($header['trsr_pbso_no'] != ''){                                  
                                  $voucher_status = 'VOUCHER-SETTLED';
                                  $voucher_status_bg = '#20ff80';
                                }else{                                  
                                  $voucher_status = 'VOUCHER-UNSETTLED';
                                  $voucher_status_bg = '#FF6347';
                                } ?>

                                <div class="SRSBox" style="background-color:<?php echo $voucher_status_bg; ?>"> 
                                 <?php echo $voucher_status; ?>
                                </div><?php 
                            }

                        } ?>      

                    </div>  

                    <div class="clearfix"></div>
                            
                    <!-- container kolom -->
                    <div class="col-md-6 col-xs-12">      
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">  
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_no">Sales Return #</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                <input type="text" name="trsr_no" class="form-control" readonly id="trsr_no" placeholder="Auto" value="<?php echo (($action == 'view') ? $header['trsr_no'] : '' ); ?>">
                            </div>
                          </div>                          
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_msus_no">User:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trsr_msus_no" id="trsr_msus_no" class="form-control" readonly disabled value="<?php //echo (($action == 'view') ? $header['trsr_msus_no']. ' - '. $header['msus_nm'] : $this->session->userdata('user_aktif')['msus_no']. ' - ' . $this->session->userdata('user_aktif')['msus_nm']); ?>">
                              </div>                                                        
                          </div> -->
                          <!-- <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_tgl">Date:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trsr_tgl" id="trsr_tgl" class="form-control" readonly disabled value="<?php //echo (($action == 'view') ? $header['trsr_tgl'] : date('Y-m-d') ); ?>">
                              </div>                                                        
                          </div> -->                          
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_tglterima">Date of Receipt:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                <input type="text" name="trsr_tglterima" id="trsr_tglterima" readonly disabled placeholder="Date of Receipt" class="form-control" value="<?php echo (($action == 'view') ? $header['trsr_tglterima'] : ''); ?>">
                              </div>                                                        
                          </div>                          
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_mscs_no">Customer:</label>
                              <div class="col-md-9 col-sm-9 col-xs-9 srstyle-nopadding">
                                 <input type="text" name="trsr_mscs_no" class="form-control" id="trsr_mscs_no" readonly placeholder="Customer" value="<?php echo fset_input_customer($action, $header,''); ?>">
                              </div>
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_msgd_no">Warehouse:<b class="srstyle-Tanda-Harus-Diisi">*</b></label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-boxinputicon">            
                                <div class="srstyle-combobox">
                                  <div id="trsr_msgd_no" name="trsr_msgd_no"></div> 
                                </div>            
                                <i class="material-icons srstyle-cursor srstyle-inputicon btn-view-gudang">link</i>
                              </div>                              
                          </div>                          
                          <div style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>" class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_jenis">Type:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding srstyle-input-area-radio">
                                <input name="trsr_jenis" type="radio" id="trsr_jenisc" value="C" class="radio-col-green" checked/>
                                <label for="trsr_jenisc">Cashback</label>
                                <input name="trsr_jenis" type="radio" id="trsr_jenisv" value="V" class="radio-col-green"/>
                                <label for="trsr_jenisv">Sales Return Voucher</label>            
                              </div>
                          </div>                                                                               
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                              <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_tag">Tag:</label>
                              <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">
                                 <input type="text" name="trsr_tag" class="form-control" placeholder="Input Tag" id="trsr_tag" maxlength="100" value="<?php echo (($action == 'view') ? $header['trsr_tag'] : ''); ?>">
                              </div>                            
                          </div>
                          <div class="form-group form-group-sm col-md-12 srstyle-nopadding">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12 srstyle-nopadding" for="trsr_catatan">Notes:</label>
                            <div class="col-md-9 col-sm-9 col-xs-12 srstyle-nopadding">                            
                              <textarea name="trsr_catatan" class="form-control srstyle-textarea" rows="3" id="trsr_catatan" placeholder="Input Notes" maxlength="250"><?php echo (($action == 'view') ? $header['trsr_catatan'] : ''); ?></textarea>
                            </div>
                          </div>      
                     </div>     
                    <!-- End container kolom -->            
                    
                    <!-- container kolom -->
                    <div class="col-md-6 col-xs-12">   
                      <div style="color:red;">
                        <h4>PERHATIAN !</h4>
                        <h5>Jika barang yang diretur tidak lengkap atau tidak 100% kondisi baru, MOHON INFO TEAM ACC STOCK !</h5>
                        <h5>Terima kasih</h5>
                      </div>
                    </div>
                    
                    <div class="clearfix"></div>      

                    <!-- ========================================== Sales Retur Detail ==================================== -->        
                    <div class="tabledetail-container col-md-12 col-sm-12 col-xs-12">
                        <div class="srstyle-list-title list-title">
                          <span>Detail Sales Return<span>                                                    
                          <?php
                          if($action == 'view' && $header['trsr_tglterima'] != '0000-00-00' && fcek_hak_akses('.CCA.') && $header['trsr_void'] == 0){ ?>
                              <i id="btn-view-jurnal" class="material-icons srstyle-cursor pull-right srstyle-btntoprightdetail">chrome_reader_mode</i><?php
                          } ?>
                        </div>

                        <div class="srstyle-col-view" style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>">
                            <table>
                                  <thead>                                         
                                      <tr class="filters">                                                          
                                          <th>Total</th>
                                      </tr>  
                                  </thead>                                
                                  <tbody id="salesreturn-action-tbody">
                                        <?php
                                        if($action == 'view' || $action == 'new_import'){
                                            if(isset($detail)){ 
                                                foreach ($detail as $key => $value) { ?>
                                                    <tr>                                                
                                                        <td><input style="width:150px;" type="text" class="form-control dtsr_total srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? $value['dtsr_nett'] * $value['dtsr_qtyretur'] : ''; ?>"/></td>
                                                    </tr><?php
                                                } ?>

                                                <tr>                                                
                                                    <td><input style="width : 150px;" type="text" class="form-control srstyle-ta-right auto-numeric" id="dtsr_total" name="trsr_total" readonly value=""/></td>
                                                </tr><?php
                                            }                                           
                                          } ?>                                                                            
                                  </tbody>
                            </table>
                          </div>                    
                      

                          <div id="wrap" class="srstyle-col-content">
                              <table id="fixTable" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <thead>                                    
                                      <tr class="filters">                
                                        <th style="display:none;">Seq</th>
                                        <th class="produk_id" style="min-width:100px;">Product ID</th>                                                                                               
                                        <td class="produknamecol" style="background-color: white; text-align: center;"><b>&nbsp; &nbsp;  &nbsp;  &nbsp;  Product Name &nbsp; &nbsp; &nbsp; &nbsp;  &nbsp;  </b></td>
                                        <th style="min-width:100px;">Avaliable Stock</th>
                                        <th style="min-width:100px;">Stock</th>                                        
                                        <th>Qty Return</th>                                        
                                        
                                        <?php 
                                        if($header['trsr_void'] == 0){ ?>
                                            <th style="min-width:100px;">Delivered (Qty SD - Qty Reject)</th>
                                            <th>Qty Returned</th>
                                            <?php
                                        } ?>    

                                        <?php                        
                                        if(fcek_hak_akses('.CC9.')){ ?> 
                                              <th style="min-width:130px;">Before Tax</th>
                                              <th style="min-width:130px;">Tax</th>
                                              <th style="min-width:130px;">Nett</th>                                              
                                              <?php
                                        } ?>
                                      </tr>
                                  </thead>
                                  <tbody id="salesreturn-datadetail-tbody">
                                        <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> if view and new import  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->
                                    <?php if($action == 'view' || $action == 'new_import'){                                                                                 
                                                if(isset($detail)){
                                                    foreach ($detail as $value) { ?>
                                                        <tr>
                                                          <td style="display:none;"><input type="text" name="dtsr[dtsr_seq][]" class="form-control" readonly value="<?php echo $value['dtsd_seq']; ?>"/></td>
                                                          <td class="produk_id"><input type="text" name="dtsr[dtsr_mspd_no][]" class="form-control srstyle-ta-center dtsr_mspd_no dtsr_mspd_no_avl" readonly value="<?php echo $value['dtsd_mspd_no']; ?>"/></td>                                                      
                                                          <td class="produknamecol"><input type="text" class="form-control srstyle-col-produkname" readonly value="<?php echo $value['mspd_nm']; ?>"/></td>
                                                          <td><input type="text" class="form-control srstyle-ta-right auto-numeric <?php echo $value['dtsd_mspd_no'].'avl'; ?>" readonly value="0"/></td>
                                                          <td><input type="text" class="form-control srstyle-ta-right auto-numeric <?php echo $value['dtsd_mspd_no']; ?>" readonly value="0"/></td>                                                      
                                                          <td><input type="text" name="dtsr[dtsr_qtyretur][]" class="form-control dtsr_qtyretur srstyle-ta-right auto-numeric" data-trigger="focus" value="<?php echo ($action == 'view') ? $value['dtsr_qtyretur'] : 0; ?>"/></td>                                                      
                                                          
                                                          <?php 
                                                          if($header['trsr_void'] == 0){ ?>
                                                              <td><input type="text" name="dtsr[dtsr_qtykrmsd][]" class="form-control srstyle-ta-right auto-numeric dtsr_qtykrmsd" readonly value="<?php echo $value['dtsd_qtykrm'] - $value['dtsd_qtyrej']; ?>"/></td>
                                                              <td><input type="text" name="dtsr[dtsr_qtysudahretur][]" class="form-control srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'new') ? 0 : $value['calc_qty_retur']; ?>"/></td>
                                                              <?php
                                                          } ?>    

                                                          <td style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>"><input type="text" name="dtsr[dtsr_bftax][]" class="form-control dtsr_bftax srstyle-ta-right auto-numeric" value="<?php echo ($action == 'view') ? $value['dtsr_bftax'] : $value['dtsd_bftax']; ?>"/></td>
                                                          <td style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>"><input type="text" name="dtsr[dtsr_tax][]" class="form-control dtsr_tax srstyle-ta-right auto-numeric" readonly value="<?php echo ($action == 'view') ? $value['dtsr_tax'] : $value['dtsd_tax']; ?>"/></td>
                                                          <td style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>"><input type="text" name="dtsr[dtsr_nett][]" class="form-control dtsr_nett srstyle-ta-right auto-numeric" value="<?php echo ($action == 'view') ? $value['dtsr_nett'] : $value['dtsd_nett']; ?>"/></td>                                                          
                                                        </tr><?php
                                                      } 
                                                    } ?>

                                                    <tr id="dtsr_total" class="srstyle-rowcountdetail" style="<?php if(!fcek_hak_akses('.CC9.')){echo 'display:none;'; } ?>">
                                                        <td colspan="3" style="display: none;"></td>
                                                        <td colspan="7" class="srstyle-detailcount-label">Total</td>
                                                        <td><input type="text" id="dtsr_totalbftax" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                        <td><input type="text" id="dtsr_totaltax" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                        <td><input type="text" id="dtsr_totalnett" class="form-control srstyle-ta-right auto-numeric" value="" readonly/></td>
                                                        <td style="display:none;"><input style="width : 150px;" type="text" class="form-control srstyle-ta-right auto-numeric dtsr_netttotal_hide" value="" readonly/></td>
                                                    </tr><?php
                                          } ?>                                          
                                  <!-- >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> End if view and new import  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< -->        
                                  </tbody>
                              </table>
                          </div>
                      </div>
                    <!-- ========================================== End Sales Retur Detail ==================================== -->
                  <div class="clearfix"></div>

                  <br/>
                  <div class="col-md-6 col-xs-12 srstyle-Remark-Text">
                      <span>Require Data &nbsp;<b class="srstyle-Tanda-Harus-Diisi">*</b></span>                
                      <br/>
                  </div>

                  <div class="clearfix"></div> 
                  <!-- <input type="submit" value="submit" id="submit"/> -->
              </form>                
            <!-- ========================================== End Sales Retur Form ==================================== -->               
            
            </div>
            <?php $this->load->view('v_save_bar'); ?>
        </div>                        
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="popup-cancel-receiving-goods" role="dialog">
  <div class="modal-dialog">
  
    <!-- Modal content-->
    <div class="modal-content srstyle-confirm-box">
      <div class="modal-header srstyle-modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Confirmation</h4>
      </div>
      <div class="modal-body srstyle-comfirm-text">
        <h4>Are you sure want to cancel receiving goods?</h4>        
      </div>
      <div class="modal-footer srstyle-modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
        <button type="button" id="btn-cancel-receivinggoods-ok" class="btn btn-default">Yes</button>
      </div>
    </div>
    
  </div>
</div>  
<!-- End Modal -->  


<?php $this->load->view('v_popup_confirm_void'); ?>
<?php $this->load->view('v_popup_confirm_print'); ?>
<?php $this->load->view('v_popup_confirm_cancel'); ?> 
<?php $this->load->view('v_popup_jurnalotomatis'); ?>

<div id="popup-container"></div>

<!-- =====================================================Inisial=========================================== -->
<script type="text/javascript">
  // var wrap = $("#wrap");

  //   wrap.on("scroll", function(e) {
  //     var scrollx = $("div.srstyle-col-content").scrollLeft();  
  //     if (scrollx > 0) {
  //       $(".produknamecol").addClass("fixed_table");
  //       $(".fixededit").addClass("fixedname").css("padding-left", scrollx + "px"); 
  //       $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
  //       $(".produk_id").addClass("display_id");
  //     } 
  //     else {
  //       $(".produknamecol").removeClass("fixed_table");
  //       $(".fixededit").removeClass("fixedname").css("padding-left", scrollx + "px"); 
  //       $(".srstyle-detailcount-label").css("padding-left", scrollx + 10 + "px"); 
  //       $(".produk_id").removeClass("display_id");
  //     }
  //   });

  // $(".auto-numeric").autoNumeric("init");
  $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
  $(document).ready(function(){
      function recalc_price(){
          $('.dtsr_mspd_no').each(function(){
            if ($(this).val() != '') {
              var curr_row_left = $(this).parents("tr");
              var curr_row_right = $("#salesreturn-action-tbody tr").eq(curr_row_left.index());          
              fcountprice_from_nett(curr_row_left, curr_row_right);
            }
          });
      }
      
      var prevDate = '';

      $('#trsr_tgl').datetimepicker({
        format:'Y-m-d H:i:s',
        formatTime:'H:i',
        onShow: function(ct){
          prevDate = $('#trsr_tgl').val();
          prevDate = prevDate.substr(0, 10);
        },
        onSelectDate: function(ct){
          var seldate = ct.toISOString().split('T')[0];
          var showconf = false;

          if (prevDate < '2022-04-01' && seldate >= '2022-04-01') {
            showconf = true;
          }

          if (prevDate >= '2022-04-01' && seldate < '2022-04-01') {
            showconf = true;
          }

          if (showconf) {
            falertwarning('Perubahan tanggal retur akan merubah tarif Tax. Sistem akan menghitung ulang harga !'); 
            recalc_price();
            fcount_total();
          }

          prevDate = $('#trsr_tgl').val();
          prevDate = prevDate.substr(0, 10);
        },
      });

      $("#trsr_tglterima").datetimepicker({
          format:'Y-m-d',
          timepicker:false
      }); 

      // $("#fixTable").tableHeadFixer({"head" : false, "left" : 3});           
      var trsr_jenis = "<?php echo ($action == 'view') ? $header['trsr_jenis'] : ''; ?>";
    
      //Set menu navigai yang sedang dipilih menjadi aktif
      $("#menu-sales-retur").addClass("active");
      $("#menu-sales > a, #menu-sales-retur > a").addClass("toggled");       
      $("#ml-menu-sales").css("display","block");                      

      if(trsr_jenis == "C" || trsr_jenis == ""){
        $("#trsr_jenisc").prop("checked",true);
      }else{
        $("#trsr_jenisv").prop("checked",true);
      }

        //Ajax POST untuk combo box gudang
        $.ajax({
              method:"POST",
              url:"<?php echo base_url('gudang/get_gudang'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val()},
              dataType:"json",
              success:function(r){                
                  var arrGudang = [];                  
                  var trsr_msgd_no = "";

                  if("<?php echo $action ?>" == "view"){
                      trsr_msgd_no = "<?php echo $header['trsr_msgd_no']; ?>";
                  }
                  
                  for (var i = 0; i < r.length; i++) {              
                      if(r[i]['msgd_aktif'] == 1){                            
                            arrGudang.push({
                                value: r[i]['msgd_no'],                  
                                text: r[i]['msgd_no'] + " : " + r[i]['msgd_nm'],
                                selected: trsr_msgd_no.includes(r[i]['msgd_no']) 
                            });
                      }else{
                        if(trsr_msgd_no.includes(r[i]['msgd_no'])){
                            arrGudang.push({
                                value: r[i]['msgd_no'],
                                text: r[i]['msgd_no'] + " : " + r[i]['msgd_nm'] + ' [OFF]',
                                selected: true                      
                            });                            
                        }
                      }
                  }                  
                  dhxtrsr_msgd_no = dhtmlXComboFromSelect("trsr_msgd_no"); 
                  dhxtrsr_msgd_no.addOption(arrGudang); 
                  dhxtrsr_msgd_no.enableFilteringMode("between");
                  dhxtrsr_msgd_no.allowFreeText(false);
                  dhxtrsr_msgd_no.setPlaceholder("Select Warehouse");                                    

                  dhxtrsr_msgd_no.attachEvent("onChange", function(){                      
                      fset_infostok();                                                                  
                  });       

                  if("<?php echo $action ?>" == "view"){                    
                      dhxtrsr_msgd_no.disable();
                      fset_infostok();
                  } 
              }
        });                
        
        if("<?php echo $action; ?>" == "new_import"){                        
              vaction = "NEW";

              var tgl_so = "<?php echo $header['trso_tgl']; ?>"; 
              tgl_so = tgl_so.substr(0, 10);
              var tgl_sr = $('#trsr_tgl').val();
              tgl_sr = tgl_sr.substr(0, 10);
              showconf = false;

              if (tgl_so < '2022-04-01' && tgl_sr >= '2022-04-01') {
                showconf = true;
              }

              if (tgl_so >= '2022-04-01' && tgl_sr < '2022-04-01') {
                showconf = true;
              }

              if (showconf) {
                falertwarning('Periode Sales Order dan Sales Retur memiliki Tarif TAX yang berbeda! Sistem akan menghitung ulang TAX ini sesuai periode Sales Retur');
                recalc_price();
              }    


              $(".save-bar-container").show();
              $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-sd").hide();
              $("#btn-save").attr({"url:id":"<?php echo base_url('sales_retur/sales_retur_new_simpan'); ?>", "action":"NEW"});              
              fset_info_avaliablestock();
              // fcount_price();
              // fcount_total();              
        }

        
        if("<?php echo $action; ?>" == "new"){              
            $("#btn-import-sd").click();
            $(".navbar-right").show().find('a').not("#btn-view-list, #btn-import-sd").hide();
        }

        if("<?php echo $action; ?>" == "view"){
            if("<?php echo $header['trsr_void']; ?>" == 1){
                $("#btn-void, #btn-edit, #btn-print").hide();                                                   
            }                                        
                    
            fset_info_avaliablestock();
            fcount_total();           
            $("#sales_retur-form :input").prop("disabled", true);              
            $(".navbar-right").show().find("#btn-import-sd").hide();
            if("<?php echo $this->session->userdata('alert_sukses'); ?>" === "sukses"){
              falertsuccess();
              <?php unset($_SESSION['alert_sukses']); ?>          
            }              
        }
        
    });             
</script>
<!-- =====================================================End Inisial=========================================== -->

<!-- =====================================================Event=========================================== -->
<script type="text/javascript">
    var temp_value;

    // $( ".dtsd_qtykrm" ).bind({                  
    //       keyup: function() {
    //             var curr_row = $(this).parents("tr");
    //             var dtsd_qtysisa = parseFloat(curr_row.find(".dtsd_qtysisa").val());
    //             var dtsd_qtykrm = parseFloat($(this).val());
                
    //             if(dtsd_qtykrm > dtsd_qtysisa || dtsd_qtykrm < 0){                  
    //               $(this).popover({content: "Delivery quantity should be less than or equal to remaining quantity.", placement: "right"});
    //               $(this).popover('show');
    //               $(this).val(0);
    //             }else{
    //               $(this).popover('destroy');
    //             }                                              
    //       }
    // });


    $(".btn-view-gudang").click(function(){
          var msgd_no = dhxtrsr_msgd_no.getSelectedValue();
          if(msgd_no !== null){
            window.open(
              "<?php echo base_url('gudang/gudang_view') ?>" + "/" + msgd_no,
              "_blank"
            );
          }else{
            window.open(
              "<?php echo base_url('gudang') ?>",
              "_blank"
            );
          }
    });    

    $("#btn-conf-receiving-goods").click(function(){                
          vaction = "CONF_RECEIVING_GOODS";
          $("#trsr_tag, #trsr_catatan, [name='trsr_jenis']").prop('disabled',true);
          dhxtrsr_msgd_no.enable();
          $("#trsr_tglterima").val("<?php echo date('Y-m-d'); ?>");          
          $(".dtsr_qtyretur, #trsr_tglterima").prop({"readonly":false, "disabled":false});
          $(".dtsr_qtyretur_lama").val(0);
          $(".save-bar-container").show();
          $("#btn-save").attr({"url:id":"<?php echo base_url('sales_retur/sales_retur_edit_simpan'); ?>", "action":"CONF_RECEIVING_GOODS"});
          var message = "1. Select warehouse <br />"
                        +"2. Make sure qty return <br />"                        
                        +"3. Click save button to save confirm receiving goods";
          todolist(message);
    });    

    
    $("#btn-no").click(function(){        
        $("#popup-confirm-print").modal("hide");
        window.open("<?php echo base_url('sales_retur/sales_retur_print?trsr_no='); ?>" + $("#trsr_no").val() + "&&paper_size=A4","_blank");
    })  

    $("#btn-save-print").click(function(){        
        $("#popup-confirm-print").modal("hide");
        window.open("<?php echo base_url('sales_retur/sales_retur_print?trsr_no='); ?>" + $("#trsr_no").val() + "&&paper_size=A5","_blank");
    })

    $("#btn-print").click(function(){  
        $("#popup-confirm-print").modal();
    }); 

                      
    //Event edit sales_retur
    $(document).on('click','#btn-edit',function(){                            
        vaction = "EDIT";
        dhxtrsr_msgd_no.enable();
        $("#sales_retur-form :input").not("#trsr_tgl").prop('disabled',false);
        $("#trsr_tglterima").prop('disabled',true);
        $("#trsr_tglterima").val('0000-00-00');
        $("#btn-save").prop('disabled',false);         
        $(".save-bar-container").show();
        $("#btn-save").attr({"url:id":"<?php echo base_url('sales_retur/sales_retur_edit_simpan'); ?>", "action":"EDIT"});
        notify.close();
    });

    $("#btn-cancel-receiving-goods").click(function(){                            
        $("#popup-cancel-receiving-goods").modal();        
    });


    $("#btn-void").click(function(){           
        $("#popup-confirm-void").modal();
    });

    //Simpan data ke data base
    //VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV        
        $("#btn-cancel-receivinggoods-ok").click(function(){            
            vaction = "CANCEL_RECEIVING_GOODS";
            save_data();
        });
                                       
        //Save sales_retur ke database
        $("#btn-save").click(function(){        
            save_data();
        });

        $("#btn-save-void").click(function(){                                                            
            vaction = "VOID";
            save_data();
        });


        function save_data(){
          $("#sales_retur-form input").prop('disabled',false);
          $("#btn-save").prop('disabled',true);        
          $("#btn-save-void").prop('disabled',true);
            $("#sales_retur-form").ajaxSubmit({
                  url: "<?php echo base_url('sales_retur/sales_retur_simpan'); ?>", 
                  data:{action: vaction},
                  type: 'POST',
                  dataType:"json",      
                  success: function(result){                  
                      if (result.response == "gagal") {
                          var errmsg="";
                          $.each(result.error_message, function (index, value) {
                            errmsg += value;                            
                          });
                          $("#popup-confirm-void").modal("hide");
                          $("#popup-cancel-receiving-goods").modal("hide");
                          falertwarning(errmsg);       
                          // $("#sales_retur-form input").not(".dhxcombo_input").prop('disabled',true);                      
                          $("#btn-save, #btn-save-void").prop('disabled',false);                                   

                          if(vaction != "NEW"){  
                            $("#trsr_tgl").prop('disabled',true);
                          }

                          if(vaction == "NEW" || vaction == "EDIT"){            
                              $("#sales_retur-form :input").prop('disabled',false);
                              dhxtrsr_msgd_no.enable();
                          }

                          if(vaction == "CONF_RECEIVING_GOODS"){            
                              $("#trsr_tag, #trsr_catatan, [name='trsr_jenis']").prop('disabled',true);
                              dhxtrsr_msgd_no.enable();          
                              $(".dtsr_qtyretur").prop({"readonly":false, "disabled":false});
                          }                                                             
                      }else{                      
                          window.location.href = "<?php echo base_url('sales_retur/sales_retur_view'); ?>" + "/" + result.trsr_no;
                      }                       
                  },
                  error:function(){
                    falertwarning('Error query or syntax');
                    $("#sales_retur-form input").prop('disabled',true);
                    dhxtrsr_msgd_no.enable();
                    $("#btn-save").prop('disabled',false);                
                  }
            });          
        }
    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^        
        
    //Redirect ke sales_retur list
    $("#btn-cancel-detail").click(function(){
        window.location.href = "<?php echo base_url('sales_retur'); ?>";
    });

    $("#btn-cancel").click(function(){  
        $("#popup-confirm-cancel").modal();
       });

    $("#btn-import-sd").click(function(){            
        $.ajax({
              method:"POST",        
              url: "<?php echo base_url('sales_delivery/sales_delivery_popup'); ?>",
              data:{key:$("#key").val(), hash_key:$("#hash_key").val(), confirm_status:1, confirm_status_disabled:'disabled'}, 
              dataType:"json",
              success:function(r){                                                                
                $("#popup-container").html(r.popup);                                                            
                $("#sales-delivery-modal").modal();
              } 
          });  
    });

    $(document).on('dblclick','#salesdelivery-datalist-tbody tr',function(){
        var trsd_no = $(this).attr("data['trsd_no']");        
        window.location.href = "<?php echo base_url('sales_retur/sales_retur_new/'); ?>" + "/" + trsd_no;
    });

    $(document).on('focus','.dtsr_qtyretur, .dtsr_nett, .dtsr_bftax',function(){
        temp_value = $(this).val();
    });

    $(document).on('blur','.dtsr_qtyretur',function(){
        if(temp_value == $(this).val()){
          return false;
        }

        var curr_row_left = $(this).parents('tr');
        var curr_row_right = $("#salesreturn-action-tbody tr").eq(curr_row_left.index());
        fcountprice_from_qty(curr_row_left, curr_row_right)
        // fcount_price();
        fcount_total();  
    });

    $("#btn-view-jurnal").click(function(){                    
        $("#jurnal-modal").modal();                    
    });

    $(document).on('blur','.dtsr_nett',function(){
        if(temp_value == $(this).val()){
          return false;
        }

        var curr_row_left = $(this).parents('tr');
        var curr_row_right = $("#salesreturn-action-tbody tr").eq(curr_row_left.index());
        fcountprice_from_nett(curr_row_left, curr_row_right);
        fcount_total();           
    });

    $(document).on('blur','.dtsr_bftax',function(){              
        if(temp_value == $(this).val()){
          return false;
        }

        var curr_row_left = $(this).parents('tr');
        var curr_row_right = $("#salesreturn-action-tbody tr").eq(curr_row_left.index());
        fcountprice_from_bftax(curr_row_left, curr_row_right);
        fcount_total();    
    });
                            
</script>
<!-- =====================================================End Event=========================================== -->


<!-- =====================================================Function=========================================== -->
<script type="text/javascript">                       
      
    // function fcount_price(){        
    //     $(".dtsr_qtyretur").each(function(){          
    //         var curr_row_left = $(this).parents("tr");
    //         var curr_row_right = $("#salesreturn-action-tbody tr").eq(curr_row_left.index());            
    //         if($(this).val() > 0){
    //             var dtsr_qtyretur = parseFloat(ftodouble(curr_row_left.find(".dtsr_qtyretur").val()));          
                
    //             var dtsr_nett_hide = parseFloat(ftodouble(curr_row_left.find(".dtsr_nett_hide").val()));                      
    //             var dtsr_nett = parseFloat(ftodouble(curr_row_left.find(".dtsr_nett").val()));

    //             if(dtsr_nett != 0){
    //               dtsr_nett = dtsr_nett;
    //             }else{
    //               dtsr_nett = dtsr_nett_hide;                 
    //             }

    //             var dtsr_bftax = (dtsr_nett / 1.1);
    //             var dtsr_tax = (dtsr_nett - dtsr_bftax);
    //             var dtsr_total = dtsr_nett * dtsr_qtyretur;

    //             curr_row_left.find(".dtsr_nett").autoNumeric("set", dtsr_nett);
    //             curr_row_left.find(".dtsr_bftax").autoNumeric("set", dtsr_bftax);
    //             curr_row_left.find(".dtsr_tax").autoNumeric("set", dtsr_tax);
    //             curr_row_right.find(".dtsr_total").autoNumeric("set", dtsr_total);
    //         }else{              
    //             curr_row_left.find(".dtsr_nett").autoNumeric("set", 0);
    //             curr_row_left.find(".dtsr_bftax").autoNumeric("set", 0);
    //             curr_row_left.find(".dtsr_tax").autoNumeric("set", 0);
    //             curr_row_right.find(".dtsr_total").autoNumeric("set", 0);
    //         }
    //     });
    // }

    function fcountprice_from_qty(curr_row_left, curr_row_right){                                     
        var dtsr_nett = parseFloat(ftodouble(curr_row_left.find(".dtsr_nett").val()));
        var dtsr_qty = parseFloat(ftodouble(curr_row_left.find(".dtsr_qtyretur").val()));                                
        // var total = (dtsr_nett * dtsr_qty).toFixed(4);            
        var total = dtsr_nett * dtsr_qty;            
            
        curr_row_right.find(".dtsr_total").autoNumeric('set', total);        
    }

      function fcountprice_from_bftax(curr_row_left, curr_row_right){      
          var tgl_sr = $('#trsr_tgl').val();
          var tarifPPN = fgettarifppn(tgl_sr);

          var dtsr_bftax = parseFloat(ftodouble(curr_row_left.find(".dtsr_bftax").val()));
          var dtsr_nett = parseFloat(ftodouble(curr_row_left.find(".dtsr_nett").val()));
          var dtsr_qty = parseFloat(ftodouble(curr_row_left.find(".dtsr_qtyretur").val()));            

          var bftax = dtsr_bftax;   
          var tax = parseFloat(((tarifPPN / 100) * bftax).toFixed(4));
          var nett = bftax + tax;                    
          
          var total = nett * dtsr_qty;
          
          curr_row_left.find(".dtsr_tax").autoNumeric('set', tax);        
          curr_row_left.find(".dtsr_nett").autoNumeric('set', nett);          
          curr_row_right.find(".dtsr_total").autoNumeric('set', total);        
      }

      function fcountprice_from_nett(curr_row_left, curr_row_right){   
          var tgl_sr = $('#trsr_tgl').val();
          var tarifPPN = fgettarifppn(tgl_sr);

          var dtsr_nett = parseFloat(ftodouble(curr_row_left.find(".dtsr_nett").val()));
          var dtsr_qty = parseFloat(ftodouble(curr_row_left.find(".dtsr_qtyretur").val()));
          
          var bftax = parseFloat((dtsr_nett * 100 / (100 + tarifPPN)).toFixed(4));   
          var tax = dtsr_nett - bftax;                    
         
          var total = dtsr_nett * dtsr_qty;

          curr_row_left.find(".dtsr_bftax").autoNumeric('set', bftax);
          curr_row_left.find(".dtsr_tax").autoNumeric('set', tax);                  
          curr_row_right.find(".dtsr_total").autoNumeric('set', total);        
      }

    function fcount_total(){
          var dtsr_totalbftax = 0;
          var dtsr_totaltax = 0;
          var dtsr_totalnett = 0;
          var dtsr_total = 0;
                            
          $(".dtsr_bftax").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtsr_qtyretur").val() != 0){
                  dtsr_totalbftax += parseFloat(ftodouble($(this).val()));                  
              }  
          });

          $(".dtsr_tax").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtsr_qtyretur").val() != 0){
                  dtsr_totaltax += parseFloat(ftodouble($(this).val()));                  
              }  
          });

          $(".dtsr_nett").each(function(){ 
              var curr_row_left = $(this).parents("tr");
              if(curr_row_left.find(".dtsr_qtyretur").val() != 0){
                  dtsr_totalnett += parseFloat(ftodouble($(this).val()));
              }  
          });

          $(".dtsr_total").each(function(){ 
              var curr_row_right = $(this).parents("tr");
              var curr_row_left = $("#salesreturn-datadetail-tbody tr").eq(curr_row_right.index());
              if(curr_row_left.find(".dtsr_qtyretur").val() != 0){
                  dtsr_total += parseFloat(ftodouble($(this).val()));
              }  
          });
                    
          // $(".auto-numeric").autoNumeric('init');
          $('.auto-numeric').autoNumeric('init', {aPad:false, mDec:4});
          $("#dtsr_totalbftax").autoNumeric('set', dtsr_totalbftax);
          $("#dtsr_totaltax").autoNumeric('set', dtsr_totaltax);
          $("#dtsr_totalnett").autoNumeric('set', dtsr_totalnett);          
          $("#dtsr_total").autoNumeric('set', dtsr_total);          
      }
                       
     function falertsuccess() {      
          $.notify({
          // options
            message: "Data successfully saved."
          },{
            // settings
            type: 'success',    
            placement: {
                align: 'center'
              },
            animate:{
              enter: 'animated bounceInDown',
              exit: 'animated bounceOutUp'
            }
          });
      }      

      function todolist(message) {      
        notify =  $.notify({
                    // options
                      title: "<strong>To do list</strong><br />",
                      message: message
                    },{
                      // settings
                      type: 'info',    
                      timer: 60000,
                      offset: {
                          x : 0,
                          y : 40
                      },
                      placement: {
                          align: 'right'
                        },
                      animate:{
                        enter: 'animated fadeInRight',
                        exit: 'animated fadeOutRight'
                      }
                  });
      }              

      function falertwarning(value) {     
            $.notify({
            // options
              message: value
            },{
              // settings
              type: 'warning',              
              placement: {
                  align: 'center'
                },
              animate:{
                enter: 'animated bounceInDown',
                exit: 'animated bounceOutUp'
              }
            });
      }

      function fset_infostok(){
          var varr_mspd_no = $('.dtsr_mspd_no').map(function() {
              if($(this).val() != ""){
                return $(this).val();                
              }                          
          }).toArray();                  

          if(varr_mspd_no.length > 0){                                                                          
              $.ajax({
                  method:"POST",
                  url:"<?php echo base_url('produk/produkstok'); ?>",
                  data:{key:$("#key").val(), hash_key:$("#hash_key").val(), msgd_no:dhxtrsr_msgd_no.getSelectedValue(), arr_mspd_no:varr_mspd_no},
                  dataType:"json",
                  success:function(r){                                                           
                      for (var i = 0; i < r.length; i++) {                          
                          if(r[i]['mspd_paket'] == "N"){
                            $("." + r[i]['mspd_no']).autoNumeric('set', (r[i]['msst_qty']));                            
                          }else{
                            $("." + r[i]['mspd_no']).autoNumeric('set', 0);                                                        
                          }
                      }                                               
                  }
              });  
          }                  
      }

      function fset_info_avaliablestock(){
            var varr_mspd_no = $('.dtsr_mspd_no_avl').map(function() {
                if($(this).val() != ""){
                  return $(this).val();
                }                          
            }).toArray();                  

            if(varr_mspd_no.length > 0){                                                                          
                $.ajax({
                    method:"POST",
                    url:"<?php echo base_url('produk/produk_avaliablestock'); ?>",
                    data:{key:$("#key").val(), hash_key:$("#hash_key").val(), arr_mspd_no:varr_mspd_no},
                    dataType:"json",
                    success:function(r){                                                           
                        for (var i = 0; i < r.length; i++) {                                                      
                            if(r[i]['mspd_paket'] == "N"){
                              var avl_stok = (r[i]['mskt_statusinv'] == "Y") ? r[i]['mspd_qtyavl'] : 0;
                              $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', avl_stok);
                            }else{
                              $("." + r[i]['mspd_no'] + "avl").autoNumeric('set', 0);
                            }
                        }                                                
                    }
                });  
            }                  
        }
</script>
<!-- =====================================================End Function=========================================== -->

