<!DOCTYPE html>
<html>
<head>
    <title>Ajax Progress</title>
    <meta charset="utf-8">
    <link href="<?php echo base_url('asset/plugins/bootstrap/css/bootstrap.min.css'); ?>" rel="stylesheet">    
    <!-- jquery UI Css -->
    <link href="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.css'); ?>" rel="stylesheet" />
    <!-- Custom Css -->
    <link href="<?php echo base_url('asset/build/css/style.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('asset/css/style.css') ?>" rel="stylesheet">
    <script src="<?php echo base_url('asset/plugins/jquery/jquery.min.js'); ?>"></script>
    <!-- jquery UI JS -->
    <script src="<?php echo base_url('asset/plugins/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>    
    <script src="<?php echo base_url('asset/plugins/jquery-ajax-progress-master/dist/jquery.ajax-progress.js'); ?>"></script>    
    
</head>
<body style="">    
        
    <div class="container panel panel-default">
        <br/>
        <!-- start panel -->    
          <div class="panel-heading" style="background-color: orange; padding-top:15px; color:white;">
            <h6 class="panel-title">
              <span style="text-align:center;">
               Backup Data
              </span>
              <span class="pull-right">
               <a href="<?php echo base_url('backup_data/logout_backup_data'); ?>" style="color:white;">Logout</a>
              </span>
            </h6>
          </div>

        <div class="panel-body">
            <input type="hidden" name="key" id="key" value="<?php echo $key ?>" >   
            <input type="hidden" name="hash_key" id="hash_key" value="<?php echo $hash_key ?>" >
            <input name="filter" type="radio" id="filter_all" value="all" class="radio-col-green" checked/>
            <label class="control-label col-md-3 col-md-3 col-xs-12 srstyle-nopadding" for="filter_all">All </label>      
            <div class="clearfix"></div>   
            <input name="filter" type="radio" id="filter_periode" value="periode" class="radio-col-green"/>
            <label class="control-label col-md-3 col-md-3 col-xs-12 srstyle-nopadding" for="filter_periode">Date </label>
            <div class="col-md-4 col-sm-4 col-xs-4 srstyle-nopadding srstyle-boxinputicon" id="container-calendar">
              <input type="text" name="fromdate" id="fromdate" class="form-control datepicker" value="<?php echo date('Y-m-d'); ?> ">          
            </div>
             <div class="control-label col-md-1 col-sm-1 col-xs-1 srstyle-nopadding" for="" style="text-align: center; margin-top: 0.2cm"> Until </div>
            <div class="col-md-4 col-sm-4 col-xs-4 srstyle-nopadding srstyle-boxinputicon" id="container-calendar">
              <input type="text" name="todate" id="todate" class="form-control datepicker" value="<?php echo date('Y-m-d'); ?> "> 
            </div>      
        </div>

        <button id="btn-save" type="button" name="submit_backup_data" value="dfa" class="btn btn-default srstyle-button pull-right"><span class="glyphicon glyphicon-saved"> </span> OK</button>    
        <div class="clearfix"></div>
        <br/>    
    <!-- End start panel -->

        <br/>
        <div class="progress">
            <div id="progress" class="progress-bar progress-bar-striped active" role="progressbar" >
                <span>0%</span>
            </div>
        </div>
        <div id="hasil_backup" style="text-align:center;"></div>
        <div id="content" class="panel-body"></div>
    </div>    

<script type="text/javascript">
    $(function() {
            $("#fromdate, #todate").datetimepicker({
                  format:'Y-m-d',
                  timepicker:false
            });     
           
            function setProgress(precis) {
                var progress = $('#progress');
                progress.toggleClass('active', precis < 100);
                progress.css({
                    width: precis +'%'
                }).html('<span>'+precis+' %</span>');
            }

            $("#btn-save").click(function(){                     
                    $('#hasil_backup').html("");

                    if($("#filter_all").prop("checked") == true){
                        vfilter = "filter_all";
                    }else{
                        vfilter = "filter_periode";
                    }
                
                    $.ajax({
                        method:"POST",
                        url: "<?php echo base_url('backup_data/execute_backup_data'); ?>",
                        data: {
                            fromdate: $("#fromdate").val(),
                            todate: $("#todate").val(),
                            filter: vfilter,
                            key:$("#key").val(), 
                            hash_key:$("#hash_key").val()
                        },                    
                        success: function() {
                            if($('#msg_error').text() == ""){
                                $('#hasil_backup').html("<b>Backup data selesai (tidak ada error)</b>");
                            }else{
                                $('#hasil_backup').html("<b>Backup data selesai (dengan ada error)</b>");
                            }
                        },
                        error: function() {
                            alert('Error!');
                        },
                        progress: function(e) {           
                            if(e.srcElement){
                                $('#content').html(e.srcElement.responseText);            
                                setProgress(Math.ceil(parseInt($(".counter").last().text()) / parseInt($("#total_backup").text()) * 100));
                            }else if(e.target){                
                                $('#content').html(e.target.responseText);                                                    
                                setProgress(Math.ceil(parseInt($(".counter").last().text()) / parseInt($("#total_backup").text()) * 100));                                
                            }
                            
                        }
                    });
            });
    });
</script>
    
</body>
</html>
